/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.BuildMetrics;
import io.quarkus.builder.ItemId;
import io.quarkus.builder.Messages;
import io.quarkus.builder.diag.Diagnostic;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public final class BuildResult {
    private final ConcurrentHashMap<ItemId, BuildItem> simpleItems;
    private final ConcurrentHashMap<ItemId, List<BuildItem>> multiItems;
    private final List<Diagnostic> diagnostics;
    private final long nanos;
    private final BuildMetrics metrics;

    BuildResult(ConcurrentHashMap<ItemId, BuildItem> simpleItems, ConcurrentHashMap<ItemId, List<BuildItem>> multiItems, Set<ItemId> finalIds, List<Diagnostic> diagnostics, long nanos, BuildMetrics metrics) {
        this.simpleItems = simpleItems;
        this.multiItems = multiItems;
        this.diagnostics = diagnostics;
        this.nanos = nanos;
        this.metrics = metrics;
    }

    public <T extends SimpleBuildItem> T consume(Class<T> type) {
        ItemId itemId = new ItemId(type);
        BuildItem item = this.simpleItems.get(itemId);
        if (item == null) {
            throw Messages.msg.undeclaredItem(itemId);
        }
        return (T)((SimpleBuildItem)type.cast(item));
    }

    public <T extends SimpleBuildItem> T consumeOptional(Class<T> type) {
        ItemId itemId = new ItemId(type);
        BuildItem item = this.simpleItems.get(itemId);
        if (item == null) {
            return null;
        }
        return (T)((SimpleBuildItem)type.cast(item));
    }

    public <T extends MultiBuildItem> List<T> consumeMulti(Class<T> type) {
        ItemId itemId = new ItemId(type);
        List<BuildItem> items = this.multiItems.get(itemId);
        if (items == null) {
            return Collections.emptyList();
        }
        return new ArrayList<BuildItem>(items);
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public long getDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.nanos, TimeUnit.NANOSECONDS);
    }

    public BuildMetrics getMetrics() {
        return this.metrics;
    }

    public void closeAll() throws RuntimeException {
        for (BuildItem buildItem : this.simpleItems.values()) {
            if (!(buildItem instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)buildItem)).close();
            }
            catch (Exception e) {
                Messages.msg.closeFailed(buildItem, e);
            }
        }
        for (List list : this.multiItems.values()) {
            for (BuildItem obj : list) {
                if (!(obj instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)((Object)obj)).close();
                }
                catch (Exception e) {
                    Messages.msg.closeFailed(obj, e);
                }
            }
        }
    }
}

