/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BooleanExpression;
import org.jboss.byteman.rule.expression.ClassLiteralExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class InstanceOfExpression
extends BooleanExpression {
    Class<?> testType = null;

    public InstanceOfExpression(Rule rule, int oper, ParseNode token, Expression left, ClassLiteralExpression right) {
        super(rule, oper, token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(Type.UNDEFINED);
        Type type2 = this.getOperand(1).typeCheck(Type.UNDEFINED);
        if (type1 == null || !type1.isObject()) {
            throw new TypeException("InstanceExpression.typeCheck : left hand side of instanceof must be of object type " + this.getPos());
        }
        if (type2 == null || !type2.isObject() || type2.getTargetClass() != Class.class) {
            throw new TypeException("InstanceExpression.typeCheck : right hand side of instanceof must be a class literal " + this.getPos());
        }
        this.testType = (Class)this.getOperand(1).interpret(null);
        return Type.B;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Object lhs = this.getOperand(0).interpret(helper);
        return this.testType.isInstance(lhs);
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int expected = 1;
        this.getOperand(0).compile(mv, compileContext);
        mv.visitTypeInsn(193, Type.internalName(this.testType));
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("InstanceOfExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }
}

