/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.dom.xmlsec.w3.xmldsig;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import org.keycloak.common.util.Base64;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyValueType;
import org.keycloak.saml.common.exceptions.ProcessingException;

public class DSAKeyValueType
implements KeyValueType {
    protected byte[] p;
    protected byte[] q;
    protected byte[] g;
    protected byte[] y;
    protected byte[] j;
    protected byte[] seed;
    protected byte[] pgenCounter;

    public byte[] getP() {
        return this.p;
    }

    public void setP(byte[] value) {
        this.p = value;
    }

    public byte[] getQ() {
        return this.q;
    }

    public void setQ(byte[] value) {
        this.q = value;
    }

    public byte[] getG() {
        return this.g;
    }

    public void setG(byte[] value) {
        this.g = value;
    }

    public byte[] getY() {
        return this.y;
    }

    public void setY(byte[] value) {
        this.y = value;
    }

    public byte[] getJ() {
        return this.j;
    }

    public void setJ(byte[] value) {
        this.j = value;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public void setSeed(byte[] value) {
        this.seed = value;
    }

    public byte[] getPgenCounter() {
        return this.pgenCounter;
    }

    public void setPgenCounter(byte[] value) {
        this.pgenCounter = value;
    }

    public DSAPublicKey convertToPublicKey() throws ProcessingException {
        try {
            BigInteger BigY = new BigInteger(1, this.massage(Base64.decode((String)new String(this.y))));
            BigInteger BigP = new BigInteger(1, this.massage(Base64.decode((String)new String(this.p))));
            BigInteger BigQ = new BigInteger(1, this.massage(Base64.decode((String)new String(this.q))));
            BigInteger BigG = new BigInteger(1, this.massage(Base64.decode((String)new String(this.g))));
            KeyFactory dsaKeyFactory = KeyFactory.getInstance("dsa");
            DSAPublicKeySpec kspec = new DSAPublicKeySpec(BigY, BigP, BigQ, BigG);
            return (DSAPublicKey)dsaKeyFactory.generatePublic(kspec);
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }

    public DSAPrivateKey convertToPrivateKey() throws ProcessingException {
        try {
            BigInteger BigY = new BigInteger(1, this.massage(Base64.decode((String)new String(this.y))));
            BigInteger BigP = new BigInteger(1, this.massage(Base64.decode((String)new String(this.p))));
            BigInteger BigQ = new BigInteger(1, this.massage(Base64.decode((String)new String(this.q))));
            BigInteger BigG = new BigInteger(1, this.massage(Base64.decode((String)new String(this.g))));
            KeyFactory dsaKeyFactory = KeyFactory.getInstance("dsa");
            DSAPrivateKeySpec kspec = new DSAPrivateKeySpec(BigY, BigP, BigQ, BigG);
            return (DSAPrivateKey)dsaKeyFactory.generatePrivate(kspec);
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }

    public String toString() {
        String prefix = "ds";
        String colon = ":";
        String left = "<";
        String right = ">";
        String slash = "/";
        StringBuilder sb = new StringBuilder();
        sb.append(left).append(prefix).append(colon).append("DSAKeyValue").append(right);
        if (this.p != null) {
            sb.append(left).append(prefix).append(colon).append("P").append(right);
            sb.append(new String(this.getP()));
            sb.append(left).append(slash).append(prefix).append(colon).append("P").append(right);
        }
        if (this.q != null) {
            sb.append(left).append(prefix).append(colon).append("Q").append(right);
            sb.append(new String(this.getQ()));
            sb.append(left).append(slash).append(prefix).append(colon).append("Q").append(right);
        }
        if (this.g != null) {
            sb.append(left).append(prefix).append(colon).append("G").append(right);
            sb.append(new String(this.getG()));
            sb.append(left).append(slash).append(prefix).append(colon).append("G").append(right);
        }
        if (this.y != null) {
            sb.append(left).append(prefix).append(colon).append("Y").append(right);
            sb.append(new String(this.getY()));
            sb.append(left).append(slash).append(prefix).append(colon).append("Y").append(right);
        }
        if (this.seed != null) {
            sb.append(left).append(prefix).append(colon).append("Seed").append(right);
            sb.append(new String(this.getSeed()));
            sb.append(left).append(slash).append(prefix).append(colon).append("Seed").append(right);
        }
        if (this.pgenCounter != null) {
            sb.append(left).append(prefix).append(colon).append("PgenCounter").append(right);
            sb.append(new String(this.getPgenCounter()));
            sb.append(left).append(slash).append(prefix).append(colon).append("PgenCounter").append(right);
        }
        sb.append(left).append(slash).append(prefix).append(colon).append("DSAKeyValue").append(right);
        return sb.toString();
    }

    private byte[] massage(byte[] byteArray) {
        if (byteArray[0] == 0) {
            byte[] substring = new byte[byteArray.length - 1];
            System.arraycopy(byteArray, 1, substring, 0, byteArray.length - 1);
            return substring;
        }
        return byteArray;
    }
}

