/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.common.SessionAttributesUtils;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.file.FileMapStorageProvider;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class FileMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "file";
    private Path rootRealmsDirectory;
    private final Map<String, Function<String, Path>> rootAreaDirectories = new HashMap<String, Function<String, Path>>();
    private final int factoryId = SessionAttributesUtils.grabNewFactoryIdentifier();
    protected static final Map<Class<?>, Function<?, String[]>> UNIQUE_HUMAN_READABLE_NAME_FIELD;
    private static final Pattern FORBIDDEN_CHARACTERS;

    public MapStorageProvider create(KeycloakSession session) {
        return (MapStorageProvider)SessionAttributesUtils.createProviderIfAbsent((KeycloakSession)session, (int)this.factoryId, FileMapStorageProvider.class, session1 -> new FileMapStorageProvider((KeycloakSession)session1, this, this.factoryId));
    }

    public String getHelpText() {
        return "File Map Storage";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public void init(Config.Scope config) {
        String dir = config.get("dir");
        this.rootRealmsDirectory = dir == null ? null : Path.of(dir, new String[0]);
        ModelEntityUtil.getModelNames().stream().filter(n -> !Objects.equals(n, ModelEntityUtil.getModelName(RealmModel.class))).forEach(n -> this.rootAreaDirectories.put((String)n, FileMapStorageProviderFactory.getRootDir(this.rootRealmsDirectory, n, config.get("dir." + n))));
        if (this.rootAreaDirectories != null) {
            this.rootAreaDirectories.put(ModelEntityUtil.getModelName(RealmModel.class), realmId -> realmId == null ? this.rootRealmsDirectory : this.rootRealmsDirectory.resolve((String)realmId));
        }
    }

    private static Function<String, Path> getRootDir(Path rootRealmsDirectory, String areaName, String dirFromConfig) {
        if (dirFromConfig != null) {
            Path p2 = Path.of(dirFromConfig, new String[0]);
            return realmId -> p2;
        }
        if (rootRealmsDirectory == null) {
            return p -> {
                throw new IllegalStateException("Directory for " + areaName + " area not configured.");
            };
        }
        Path a = areaName.startsWith("authz-") ? Path.of("authz", areaName.substring(6)) : Path.of(areaName, new String[0]);
        return realmId -> {
            if (realmId == null || FORBIDDEN_CHARACTERS.matcher((CharSequence)realmId).find()) {
                throw new IllegalArgumentException("Realm needed for constructing the path to " + areaName + " but not known or invalid: " + realmId);
            }
            Path path = rootRealmsDirectory.resolve((String)realmId).resolve(a);
            return path;
        };
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Function<String, Path> getDataDirectoryFunc(String areaName) {
        return this.rootAreaDirectories.get(areaName);
    }

    private static /* synthetic */ String[] lambda$static$10(MapScopeEntity v) {
        return new String[]{v.getResourceServerId(), v.getName()};
    }

    private static /* synthetic */ String[] lambda$static$9(MapResourceEntity v) {
        return new String[]{v.getResourceServerId(), v.getName()};
    }

    private static /* synthetic */ String[] lambda$static$8(MapPermissionTicketEntity v) {
        return new String[]{v.getResourceServerId(), v.getId()};
    }

    private static /* synthetic */ String[] lambda$static$7(MapPolicyEntity v) {
        return new String[]{v.getResourceServerId(), v.getName()};
    }

    private static /* synthetic */ String[] lambda$static$6(MapResourceServerEntity v) {
        return new String[]{v.getClientId()};
    }

    private static /* synthetic */ String[] lambda$static$5(MapUserEntity v) {
        return new String[]{v.getUsername()};
    }

    private static /* synthetic */ String[] lambda$static$4(MapRoleEntity v) {
        String[] stringArray;
        if (v.getClientId() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = v.getName();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = v.getClientId();
            stringArray = stringArray3;
            stringArray3[1] = v.getName();
        }
        return stringArray;
    }

    private static /* synthetic */ String[] lambda$static$3(MapRealmEntity v) {
        return new String[]{v.getName()};
    }

    private static /* synthetic */ String[] lambda$static$2(MapGroupEntity v) {
        String[] stringArray;
        if (v.getParentId() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = v.getName();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = v.getParentId();
            stringArray = stringArray3;
            stringArray3[1] = v.getName();
        }
        return stringArray;
    }

    private static /* synthetic */ String[] lambda$static$1(MapClientScopeEntity v) {
        return new String[]{v.getName()};
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.applyExpressionRewriter(NewAnonymousArray.java:112)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

