/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.UsersExportStrategy;

public class ExportImportConfig {
    public static final String PREFIX = "keycloak.migration.";
    public static final String ACTION = "keycloak.migration.action";
    public static final String ACTION_EXPORT = "export";
    public static final String ACTION_IMPORT = "import";
    public static final String PROVIDER = "keycloak.migration.provider";
    public static final String PROVIDER_DEFAULT = "dir";
    public static final String REALM_NAME = "keycloak.migration.realmName";
    public static final String DIR = "keycloak.migration.dir";
    public static final String FILE = "keycloak.migration.file";
    public static final String REPLACE_PLACEHOLDERS = "keycloak.migration.replace-placeholders";
    public static final String USERS_EXPORT_STRATEGY = "keycloak.migration.usersExportStrategy";
    public static final UsersExportStrategy DEFAULT_USERS_EXPORT_STRATEGY = UsersExportStrategy.DIFFERENT_FILES;
    public static final String USERS_PER_FILE = "keycloak.migration.usersPerFile";
    public static final Integer DEFAULT_USERS_PER_FILE = 50;
    public static final String STRATEGY = "keycloak.migration.strategy";
    public static final Strategy DEFAULT_STRATEGY = Strategy.OVERWRITE_EXISTING;

    public static String getAction() {
        return System.getProperty(ACTION);
    }

    public static void setAction(String exportImportAction) {
        System.setProperty(ACTION, exportImportAction);
    }

    public static void setProvider(String exportImportProvider) {
        System.setProperty(PROVIDER, exportImportProvider);
    }

    public static void setRealmName(String realmName) {
        if (realmName != null) {
            System.setProperty(REALM_NAME, realmName);
        } else {
            System.getProperties().remove(REALM_NAME);
        }
    }

    public static void setDir(String dir) {
        System.setProperty(DIR, dir);
    }

    public static void setFile(String file) {
        System.setProperty(FILE, file);
    }

    public static boolean isReplacePlaceholders() {
        return Boolean.getBoolean(REPLACE_PLACEHOLDERS);
    }

    public static void setReplacePlaceholders(boolean replacePlaceholders) {
        System.setProperty(REPLACE_PLACEHOLDERS, String.valueOf(replacePlaceholders));
    }
}

