/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrderedModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.resources.account.AccountFormService;

public class AccountFederatedIdentityBean {
    private static OrderedModel.OrderedModelComparator<FederatedIdentityEntry> IDP_COMPARATOR_INSTANCE = new OrderedModel.OrderedModelComparator();
    private final List<FederatedIdentityEntry> identities;
    private final boolean removeLinkPossible;
    private final KeycloakSession session;

    public AccountFederatedIdentityBean(KeycloakSession session, RealmModel realm, UserModel user, URI baseUri, String stateChecker) {
        this.session = session;
        AtomicInteger availableIdentities = new AtomicInteger(0);
        this.identities = realm.getIdentityProvidersStream().filter(IdentityProviderModel::isEnabled).map(provider -> {
            String providerId = provider.getAlias();
            FederatedIdentityModel identity = this.getIdentity(session.users().getFederatedIdentitiesStream(realm, user), providerId);
            if (identity != null) {
                availableIdentities.getAndIncrement();
            }
            String displayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)session, (IdentityProviderModel)provider);
            return new FederatedIdentityEntry(identity, displayName, provider.getAlias(), provider.getAlias(), provider.getConfig() != null ? (String)provider.getConfig().get("guiOrder") : null);
        }).sorted((Comparator<FederatedIdentityEntry>)IDP_COMPARATOR_INSTANCE).collect(Collectors.toList());
        this.removeLinkPossible = availableIdentities.get() > 1 || user.getFederationLink() != null || AccountFormService.isPasswordSet(session, realm, user);
    }

    private FederatedIdentityModel getIdentity(Stream<FederatedIdentityModel> identities, String providerId) {
        return identities.filter(federatedIdentityModel -> Objects.equals(federatedIdentityModel.getIdentityProvider(), providerId)).findFirst().orElse(null);
    }

    public List<FederatedIdentityEntry> getIdentities() {
        return this.identities;
    }

    public boolean isRemoveLinkPossible() {
        return this.removeLinkPossible;
    }

    public static class FederatedIdentityEntry
    implements OrderedModel {
        private FederatedIdentityModel federatedIdentityModel;
        private final String providerId;
        private final String providerName;
        private final String guiOrder;
        private final String displayName;

        public FederatedIdentityEntry(FederatedIdentityModel federatedIdentityModel, String displayName, String providerId, String providerName, String guiOrder) {
            this.federatedIdentityModel = federatedIdentityModel;
            this.displayName = displayName;
            this.providerId = providerId;
            this.providerName = providerName;
            this.guiOrder = guiOrder;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public String getUserId() {
            return this.federatedIdentityModel != null ? this.federatedIdentityModel.getUserId() : null;
        }

        public String getUserName() {
            return this.federatedIdentityModel != null ? this.federatedIdentityModel.getUserName() : null;
        }

        public boolean isConnected() {
            return this.federatedIdentityModel != null;
        }

        public String getGuiOrder() {
            return this.guiOrder;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

