/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ScopeMappedClientResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.util.ScopeMappedUtil;

public class ScopeMappedResource {
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    protected ScopeContainerModel scopeContainer;
    protected KeycloakSession session;
    protected AdminEventBuilder adminEvent;

    public ScopeMappedResource(RealmModel realm, AdminPermissionEvaluator auth, ScopeContainerModel scopeContainer, KeycloakSession session, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck managePermission, AdminPermissionEvaluator.RequirePermissionCheck viewPermission) {
        this.realm = realm;
        this.auth = auth;
        this.scopeContainer = scopeContainer;
        this.session = session;
        this.adminEvent = adminEvent.resource(ResourceType.REALM_SCOPE_MAPPING);
        this.managePermission = managePermission;
        this.viewPermission = viewPermission;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Deprecated
    public MappingsRepresentation getScopeMappings() {
        Stream clients;
        Map clientMappings;
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        MappingsRepresentation all = new MappingsRepresentation();
        List realmRep = this.scopeContainer.getRealmScopeMappingsStream().map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        if (!realmRep.isEmpty()) {
            all.setRealmMappings(realmRep);
        }
        if (!(clientMappings = (clients = this.realm.getClientsStream()).map(c -> ScopeMappedUtil.toClientMappingsRepresentation(c, this.scopeContainer)).filter(Objects::nonNull).collect(Collectors.toMap(ClientMappingsRepresentation::getClient, Function.identity()))).isEmpty()) {
            all.setClientMappings(clientMappings);
        }
        return all;
    }

    @Path(value="realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getRealmScopeMappings() {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.scopeContainer.getRealmScopeMappingsStream().map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getAvailableRealmScopeMappings() {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.realm.getRolesStream().filter(((Predicate<RoleModel>)arg_0 -> ((ScopeContainerModel)this.scopeContainer).hasDirectScope(arg_0)).negate()).filter(this.auth.roles()::canMapClientScope).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getCompositeRealmScopeMappings(@QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        Function<RoleModel, RoleRepresentation> toBriefRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return this.realm.getRolesStream().filter(arg_0 -> ((ScopeContainerModel)this.scopeContainer).hasScope(arg_0)).map(toBriefRepresentation);
    }

    @Path(value="realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmScopeMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRoleById(role.getId());
            if (roleModel == null) {
                throw new NotFoundException("Role not found");
            }
            this.scopeContainer.addScopeMapping(roleModel);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @Path(value="realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmScopeMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        if (roles == null) {
            roles = this.scopeContainer.getRealmScopeMappingsStream().peek(arg_0 -> ((ScopeContainerModel)this.scopeContainer).deleteScopeMapping(arg_0)).map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRoleById(role.getId());
                if (roleModel == null) {
                    throw new NotFoundException("Role not found");
                }
                this.scopeContainer.deleteScopeMapping(roleModel);
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @Path(value="clients/{client}")
    public ScopeMappedClientResource getClientByIdScopeMappings(@PathParam(value="client") String client) {
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client");
        }
        return new ScopeMappedClientResource(this.realm, this.auth, this.scopeContainer, this.session, clientModel, this.adminEvent, this.managePermission, this.viewPermission);
    }
}

