/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.util.Map;
import javax.security.auth.Subject;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.hotrod.configuration.AbstractHotRodServerChildConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerChildConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.SaslConfigurationBuilder;
import org.infinispan.server.hotrod.logging.Log;

public class AuthenticationConfigurationBuilder
extends AbstractHotRodServerChildConfigurationBuilder
implements Builder<AuthenticationConfiguration> {
    private final AttributeSet attributes;
    private static final Log log = (Log)LogFactory.getLog(AuthenticationConfigurationBuilder.class, Log.class);
    private boolean enabled = false;
    private ServerAuthenticationProvider serverAuthenticationProvider;
    private Subject serverSubject;
    private SaslConfigurationBuilder sasl = new SaslConfigurationBuilder();

    AuthenticationConfigurationBuilder(HotRodServerChildConfigurationBuilder builder) {
        super(builder);
        this.attributes = AuthenticationConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public AuthenticationConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public AuthenticationConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public AuthenticationConfigurationBuilder serverAuthenticationProvider(ServerAuthenticationProvider serverAuthenticationProvider) {
        this.serverAuthenticationProvider = serverAuthenticationProvider;
        return this;
    }

    public AuthenticationConfigurationBuilder addMechanisms(String ... mechs) {
        this.sasl.addMechanisms(mechs);
        return this;
    }

    public boolean hasMechanisms() {
        return this.sasl.hasMechanisms();
    }

    public AuthenticationConfigurationBuilder addAllowedMech(String mech) {
        this.sasl.addAllowedMech(mech);
        return this;
    }

    public AuthenticationConfigurationBuilder mechProperties(Map<String, String> mechProperties) {
        this.sasl.setMechProperty(mechProperties);
        return this;
    }

    public AuthenticationConfigurationBuilder addMechProperty(String key, String value) {
        this.sasl.addMechProperty(key, value);
        return this;
    }

    public AuthenticationConfigurationBuilder serverName(String serverName) {
        this.sasl.serverName(serverName);
        return this;
    }

    public AuthenticationConfigurationBuilder serverSubject(Subject serverSubject) {
        this.serverSubject = serverSubject;
        return this;
    }

    public AuthenticationConfigurationBuilder securityRealm(String name) {
        this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).set((Object)name);
        return this;
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).get();
    }

    public boolean hasSecurityRealm() {
        return !this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).isNull();
    }

    public SaslConfigurationBuilder sasl() {
        return this.sasl;
    }

    public void validate() {
        if (this.enabled) {
            if (this.serverAuthenticationProvider == null) {
                throw log.serverAuthenticationProvider();
            }
            this.sasl.validate();
        }
    }

    public AuthenticationConfiguration create() {
        return new AuthenticationConfiguration(this.attributes.protect(), this.sasl.create(), this.enabled, this.serverAuthenticationProvider, this.serverSubject);
    }

    public Builder<?> read(AuthenticationConfiguration template) {
        this.enabled = template.enabled();
        this.serverAuthenticationProvider = template.serverAuthenticationProvider();
        this.sasl.read(template.sasl());
        return this;
    }
}

