/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import liquibase.AbstractExtensibleObject;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;

public abstract class AbstractResourceAccessor
extends AbstractExtensibleObject
implements ResourceAccessor {
    @Override
    public InputStream openStream(String relativeTo, String streamPath) throws IOException {
        InputStreamList streamList = this.openStreams(relativeTo, streamPath);
        if (streamList == null || streamList.size() == 0) {
            return null;
        }
        if (streamList.size() > 1) {
            String message = "Found " + streamList.size() + " files with the path '" + streamPath + "':" + System.lineSeparator();
            for (URI uri : streamList.getURIs()) {
                message = message + "    - " + uri.toString() + System.lineSeparator();
            }
            message = message + "  Search Path: " + System.lineSeparator();
            for (String location : Scope.getCurrentScope().getResourceAccessor().describeLocations()) {
                message = message + "    - " + location + System.lineSeparator();
            }
            message = message + "  You can limit the search path to remove duplicates with the liquibase.searchPath setting.";
            GlobalConfiguration.DuplicateFileMode mode = GlobalConfiguration.DUPLICATE_FILE_MODE.getCurrentValue();
            Logger log = Scope.getCurrentScope().getLog(this.getClass());
            if (mode == GlobalConfiguration.DuplicateFileMode.ERROR) {
                throw new IOException(message + " Or, if you KNOW these are the exact same file you can set liquibase.duplicateFileMode=WARN.");
            }
            if (mode == GlobalConfiguration.DuplicateFileMode.WARN) {
                String warnMessage = message + System.lineSeparator() + "  To fail when duplicates are found, set liquibase.duplicateFileMode=ERROR" + System.lineSeparator() + "  Choosing: " + streamList.getURIs().get(0);
                Scope.getCurrentScope().getUI().sendMessage(warnMessage);
                log.warning(warnMessage);
                InputStream returnStream = null;
                Iterator<InputStream> iterator = streamList.iterator();
                while (iterator.hasNext()) {
                    if (returnStream == null) {
                        returnStream = iterator.next();
                        continue;
                    }
                    iterator.next().close();
                }
                return returnStream;
            }
            throw new UnexpectedLiquibaseException("Unexpected DuplicateFileMode: " + (Object)((Object)mode));
        }
        return streamList.iterator().next();
    }
}

