/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.component.ComponentModelScope;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntityImpl;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntityImpl;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntityImpl;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.authorization.entity.MapPolicyEntityImpl;
import org.keycloak.models.map.authorization.entity.MapResourceEntityImpl;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntityImpl;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntityImpl;
import org.keycloak.models.map.client.MapClientEntityImpl;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;
import org.keycloak.models.map.clientscope.MapClientScopeEntityImpl;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.common.SessionAttributesUtils;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.events.MapAdminEventEntity;
import org.keycloak.models.map.events.MapAdminEventEntityImpl;
import org.keycloak.models.map.events.MapAuthEventEntity;
import org.keycloak.models.map.events.MapAuthEventEntityImpl;
import org.keycloak.models.map.group.MapGroupEntityImpl;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureEntity;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureEntityImpl;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.realm.MapRealmEntityImpl;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntityImpl;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntityImpl;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntityImpl;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntityImpl;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.realm.entity.MapComponentEntityImpl;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntityImpl;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntityImpl;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntityImpl;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntityImpl;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntityImpl;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntityImpl;
import org.keycloak.models.map.role.MapRoleEntityImpl;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntityImpl;
import org.keycloak.models.map.storage.CrudOperations;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapCrudOperations;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorageProvider;
import org.keycloak.models.map.storage.chm.SingleUseObjectConcurrentHashMapCrudOperations;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.user.MapUserConsentEntityImpl;
import org.keycloak.models.map.user.MapUserCredentialEntityImpl;
import org.keycloak.models.map.user.MapUserEntityImpl;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntityImpl;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntityImpl;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntityImpl;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class ConcurrentHashMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "concurrenthashmap";
    private static final Logger LOG = Logger.getLogger(ConcurrentHashMapStorageProviderFactory.class);
    private final ConcurrentHashMap<String, CrudOperations<?, ?>> storages = new ConcurrentHashMap();
    private final Map<String, StringKeyConverter> keyConverters = new HashMap<String, StringKeyConverter>();
    private File storageDirectory;
    private String suffix;
    private StringKeyConverter defaultKeyConverter;
    private final int factoryId = SessionAttributesUtils.grabNewFactoryIdentifier();
    protected static final DeepCloner CLONER = new DeepCloner.Builder().genericCloner(Serialization::from).constructor(MapClientEntityImpl.class, MapClientEntityImpl::new).constructor(MapProtocolMapperEntity.class, MapProtocolMapperEntityImpl::new).constructor(MapGroupEntityImpl.class, MapGroupEntityImpl::new).constructor(MapRoleEntityImpl.class, MapRoleEntityImpl::new).constructor(MapUserEntityImpl.class, MapUserEntityImpl::new).constructor(MapUserCredentialEntityImpl.class, MapUserCredentialEntityImpl::new).constructor(MapUserFederatedIdentityEntityImpl.class, MapUserFederatedIdentityEntityImpl::new).constructor(MapUserConsentEntityImpl.class, MapUserConsentEntityImpl::new).constructor(MapClientScopeEntityImpl.class, MapClientScopeEntityImpl::new).constructor(MapResourceServerEntityImpl.class, MapResourceServerEntityImpl::new).constructor(MapResourceEntityImpl.class, MapResourceEntityImpl::new).constructor(MapScopeEntity.class, MapScopeEntityImpl::new).constructor(MapPolicyEntity.class, MapPolicyEntityImpl::new).constructor(MapPermissionTicketEntity.class, MapPermissionTicketEntityImpl::new).constructor(MapRealmEntity.class, MapRealmEntityImpl::new).constructor(MapAuthenticationExecutionEntity.class, MapAuthenticationExecutionEntityImpl::new).constructor(MapAuthenticationFlowEntity.class, MapAuthenticationFlowEntityImpl::new).constructor(MapAuthenticatorConfigEntity.class, MapAuthenticatorConfigEntityImpl::new).constructor(MapClientInitialAccessEntity.class, MapClientInitialAccessEntityImpl::new).constructor(MapComponentEntity.class, MapComponentEntityImpl::new).constructor(MapIdentityProviderEntity.class, MapIdentityProviderEntityImpl::new).constructor(MapIdentityProviderMapperEntity.class, MapIdentityProviderMapperEntityImpl::new).constructor(MapOTPPolicyEntity.class, MapOTPPolicyEntityImpl::new).constructor(MapRequiredActionProviderEntity.class, MapRequiredActionProviderEntityImpl::new).constructor(MapRequiredCredentialEntity.class, MapRequiredCredentialEntityImpl::new).constructor(MapWebAuthnPolicyEntity.class, MapWebAuthnPolicyEntityImpl::new).constructor(MapRootAuthenticationSessionEntity.class, MapRootAuthenticationSessionEntityImpl::new).constructor(MapAuthenticationSessionEntity.class, MapAuthenticationSessionEntityImpl::new).constructor(MapUserLoginFailureEntity.class, MapUserLoginFailureEntityImpl::new).constructor(MapUserSessionEntity.class, MapUserSessionEntityImpl::new).constructor(MapAuthenticatedClientSessionEntity.class, MapAuthenticatedClientSessionEntityImpl::new).constructor(MapAuthEventEntity.class, MapAuthEventEntityImpl::new).constructor(MapAdminEventEntity.class, MapAdminEventEntityImpl::new).constructor(MapSingleUseObjectEntity.class, MapSingleUseObjectEntityImpl::new).build();
    private static final Map<String, StringKeyConverter> KEY_CONVERTERS = new HashMap<String, StringKeyConverter>();

    public MapStorageProvider create(KeycloakSession session) {
        return SessionAttributesUtils.createProviderIfAbsent(session, this.factoryId, ConcurrentHashMapStorageProvider.class, session1 -> new ConcurrentHashMapStorageProvider(session, this, this.factoryId));
    }

    public void init(Config.Scope config) {
        this.suffix = config instanceof ComponentModelScope ? "-" + ((ComponentModelScope)config).getComponentId() : "";
        String keyType = config.get("keyType", "uuid");
        this.defaultKeyConverter = this.getKeyConverter(keyType);
        for (String name : ModelEntityUtil.getModelNames()) {
            this.keyConverters.put(name, this.getKeyConverter(config.get("keyType." + name, keyType)));
        }
        String dir = config.get("dir");
        try {
            if (dir == null || dir.trim().isEmpty()) {
                LOG.warn((Object)"No directory set, created objects will not survive server restart");
                this.storageDirectory = null;
            } else {
                File f = new File(dir);
                Files.createDirectories(f.toPath(), new FileAttribute[0]);
                if (f.exists()) {
                    this.storageDirectory = f;
                } else {
                    LOG.warnf("Directory cannot be used, created objects will not survive server restart: %s", (Object)dir);
                    this.storageDirectory = null;
                }
            }
        }
        catch (IOException ex) {
            LOG.warnf("Directory cannot be used, created objects will not survive server restart: %s", (Object)dir);
            this.storageDirectory = null;
        }
    }

    private StringKeyConverter getKeyConverter(String keyType) throws IllegalArgumentException {
        StringKeyConverter res = KEY_CONVERTERS.get(keyType);
        if (res == null) {
            throw new IllegalArgumentException("Unknown key type: " + keyType);
        }
        return res;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.storages.forEach(this::storeMap);
    }

    private void storeMap(String mapName, CrudOperations<?, ?> store) {
        if (mapName != null) {
            File f = this.getFile(mapName);
            try {
                if (this.storageDirectory != null) {
                    LOG.debugf("Storing contents to %s", (Object)f.getCanonicalPath());
                    DefaultModelCriteria readAllCriteria = DefaultModelCriteria.criteria();
                    Serialization.MAPPER.writeValue(f, store.read(QueryParameters.withCriteria(readAllCriteria)));
                } else {
                    LOG.debugf("Not storing contents of %s because directory not set", (Object)mapName);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private <V extends AbstractEntity & UpdatableEntity, M> CrudOperations<V, M> loadMap(final String mapName, Class<M> modelType, EnumSet<MapStorageProviderFactory.Flag> flags) {
        File f;
        StringKeyConverter kc = this.keyConverters.getOrDefault(mapName, this.defaultKeyConverter);
        Class valueType = ModelEntityUtil.getEntityType(modelType);
        LOG.debugf("Initializing new map storage: %s", (Object)mapName);
        ConcurrentHashMapCrudOperations store = modelType == SingleUseObjectValueModel.class ? new SingleUseObjectConcurrentHashMapCrudOperations(kc, CLONER){

            public String toString() {
                return "ConcurrentHashMapStorage(" + mapName + ConcurrentHashMapStorageProviderFactory.this.suffix + ")";
            }
        } : new ConcurrentHashMapCrudOperations(modelType, kc, CLONER){

            public String toString() {
                return "ConcurrentHashMapStorage(" + mapName + ConcurrentHashMapStorageProviderFactory.this.suffix + ")";
            }
        };
        if (!flags.contains((Object)MapStorageProviderFactory.Flag.INITIALIZE_EMPTY) && (f = this.getFile(mapName)) != null && f.exists()) {
            try {
                LOG.debugf("Restoring contents from %s", (Object)f.getCanonicalPath());
                Class valueImplType = CLONER.newInstanceType(valueType);
                if (valueImplType == null) {
                    valueImplType = valueType;
                }
                CollectionType type = Serialization.MAPPER.getTypeFactory().constructCollectionType(LinkedList.class, valueImplType);
                List values = (List)Serialization.MAPPER.readValue(f, (JavaType)type);
                values.forEach(mce -> store.create(mce));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return store;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public <K, V extends AbstractEntity & UpdatableEntity, M> CrudOperations<V, M> getStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        EnumSet<MapStorageProviderFactory.Flag> f = flags == null || flags.length == 0 ? EnumSet.noneOf(MapStorageProviderFactory.Flag.class) : EnumSet.of(flags[0], flags);
        String name = ModelEntityUtil.getModelName(modelType, modelType.getSimpleName());
        return this.storages.computeIfAbsent(name, n -> this.loadMap(name, modelType, f));
    }

    public StringKeyConverter<?> getKeyConverter(Class<?> modelType) {
        return this.keyConverters.getOrDefault(ModelEntityUtil.getModelName(modelType, modelType.getSimpleName()), this.defaultKeyConverter);
    }

    private File getFile(String fileName) {
        return this.storageDirectory == null ? null : new File(this.storageDirectory, "map-" + fileName + this.suffix + ".json");
    }

    public String getHelpText() {
        return "In-memory ConcurrentHashMap storage";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    static {
        KEY_CONVERTERS.put("uuid", StringKeyConverter.UUIDKey.INSTANCE);
        KEY_CONVERTERS.put("string", StringKeyConverter.StringKey.INSTANCE);
        KEY_CONVERTERS.put("ulong", StringKeyConverter.ULongKey.INSTANCE);
    }
}

