/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.LogProcessor;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.export.LogExporter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleLogProcessor
implements LogProcessor {
    private static final Logger logger = Logger.getLogger(SimpleLogProcessor.class.getName());
    private final LogExporter logExporter;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static LogProcessor create(LogExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return new SimpleLogProcessor(exporter);
    }

    SimpleLogProcessor(LogExporter logExporter) {
        this.logExporter = Objects.requireNonNull(logExporter, "logExporter");
    }

    @Override
    public void onEmit(ReadWriteLogRecord logRecord) {
        try {
            List<LogData> logs = Collections.singletonList(logRecord.toLogData());
            CompletableResultCode result = this.logExporter.export(logs);
            this.pendingExports.add(result);
            result.whenComplete(() -> {
                this.pendingExports.remove(result);
                if (!result.isSuccess()) {
                    logger.log(Level.FINE, "Exporter failed");
                }
            });
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Exporter threw an Exception", e);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> {
            CompletableResultCode shutdownResult = this.logExporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                    result.fail();
                } else {
                    result.succeed();
                }
            });
        });
        return result;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }
}

