/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.Response;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.UnicastRequest;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.RpcStats;
import org.jgroups.util.RspList;
import org.jgroups.util.StateTransferResult;

public class MessageDispatcher
implements RequestHandler,
Closeable,
ChannelListener {
    protected JChannel channel;
    protected RequestCorrelator corr;
    protected Receiver receiver;
    protected RequestHandler req_handler;
    protected boolean async_dispatching;
    protected boolean async_rsp_handling;
    protected boolean wrap_exceptions;
    protected ProtocolAdapter prot_adapter;
    protected volatile Collection<Address> members = new HashSet<Address>();
    protected Address local_addr;
    protected final Log log = LogFactory.getLog(MessageDispatcher.class);
    protected static final RspList empty_rsplist = new RspList();
    protected static final GroupRequest empty_group_request = new GroupRequest(null, Collections.emptyList(), RequestOptions.SYNC());

    public MessageDispatcher() {
    }

    public MessageDispatcher(JChannel channel) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            channel.addChannelListener(this);
            this.local_addr = channel.getAddress();
            this.installUpHandler(this.prot_adapter, true);
        }
        this.start();
    }

    public MessageDispatcher(JChannel channel, RequestHandler req_handler) {
        this(channel);
        this.setRequestHandler(req_handler);
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public RequestCorrelator getCorrelator() {
        return this.corr;
    }

    public RequestCorrelator correlator() {
        return this.corr;
    }

    public boolean getAsyncDispatching() {
        return this.async_dispatching;
    }

    public boolean asyncDispatching() {
        return this.async_dispatching;
    }

    public boolean asyncRspHandling() {
        return this.async_rsp_handling;
    }

    public MessageDispatcher asyncRspHandling(boolean f) {
        this.async_rsp_handling = f;
        if (this.corr != null) {
            this.corr.asyncRspHandling(this.async_rsp_handling);
        }
        return this;
    }

    public boolean getWrapExceptions() {
        return this.wrap_exceptions;
    }

    public boolean wrapExceptions() {
        return this.wrap_exceptions;
    }

    public UpHandler getProtocolAdapter() {
        return this.prot_adapter;
    }

    public UpHandler protocolAdapter() {
        return this.prot_adapter;
    }

    public RpcStats rpcStats() {
        return this.corr.rpc_stats;
    }

    public <X extends MessageDispatcher> X setChannel(JChannel ch) {
        if (ch == null) {
            return (X)this;
        }
        this.channel = ch;
        if (ch != null) {
            this.local_addr = this.channel.getAddress();
            ch.addChannelListener(this);
        }
        if (this.prot_adapter == null) {
            this.prot_adapter = new ProtocolAdapter();
        }
        return this.installUpHandler(this.prot_adapter, false);
    }

    public <X extends MessageDispatcher> X setCorrelator(RequestCorrelator c) {
        return this.correlator(c);
    }

    public <X extends MessageDispatcher> X correlator(RequestCorrelator c) {
        if (c == null) {
            return (X)this;
        }
        this.stop();
        this.corr = c;
        this.corr.asyncDispatching(this.async_dispatching).asyncRspHandling(this.async_rsp_handling).wrapExceptions(this.wrap_exceptions);
        this.start();
        return (X)this;
    }

    public <X extends MessageDispatcher> X setReceiver(Receiver r) {
        this.receiver = r;
        return (X)this;
    }

    public <X extends MessageDispatcher> X setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
        if (this.corr != null) {
            this.corr.setRequestHandler(rh);
        }
        return (X)this;
    }

    public <X extends MessageDispatcher> X setAsynDispatching(boolean flag) {
        return this.asyncDispatching(flag);
    }

    public <X extends MessageDispatcher> X asyncDispatching(boolean flag) {
        this.async_dispatching = flag;
        if (this.corr != null) {
            this.corr.asyncDispatching(flag);
        }
        return (X)this;
    }

    public <X extends MessageDispatcher> X setWrapExceptions(boolean flag) {
        return this.wrapExceptions(flag);
    }

    public <X extends MessageDispatcher> X wrapExceptions(boolean flag) {
        this.wrap_exceptions = flag;
        if (this.corr != null) {
            this.corr.wrapExceptions(flag);
        }
        return (X)this;
    }

    protected <X extends MessageDispatcher> X setMembers(List<Address> new_mbrs) {
        if (new_mbrs != null) {
            this.members = new HashSet<Address>(new_mbrs);
        }
        return (X)this;
    }

    public <X extends MessageDispatcher> X start() {
        if (this.corr == null) {
            this.corr = MessageDispatcher.createRequestCorrelator(this.prot_adapter, this, this.local_addr).asyncDispatching(this.async_dispatching).asyncRspHandling(this.async_rsp_handling).wrapExceptions(this.wrap_exceptions);
        }
        this.corr.start();
        if (this.channel != null) {
            List<Address> tmp_mbrs = this.channel.getView() != null ? this.channel.getView().getMembers() : null;
            this.setMembers(tmp_mbrs);
            if (this.channel instanceof JChannel) {
                TP transport = this.channel.getProtocolStack().getTransport();
                this.corr.registerProbeHandler(transport);
            }
        }
        return (X)this;
    }

    protected static RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address local_addr) {
        return new RequestCorrelator(transport, handler, local_addr);
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public <X extends MessageDispatcher> X stop() {
        if (this.corr != null) {
            this.corr.stop();
            if (this.channel instanceof JChannel) {
                TP transport = this.channel.getProtocolStack().getTransport();
                this.corr.unregisterProbeHandler(transport);
            }
        }
        return (X)this;
    }

    protected <X extends MessageDispatcher> X installUpHandler(UpHandler handler, boolean canReplace) {
        UpHandler existing = this.channel.getUpHandler();
        if (existing == null) {
            this.channel.setUpHandler(handler);
        } else if (canReplace) {
            this.log.warn("Channel already has an up handler installed (%s) but now it is being overridden", existing);
            this.channel.setUpHandler(handler);
        }
        return (X)this;
    }

    public <T> RspList<T> castMessage(Collection<Address> dests, Message msg, RequestOptions opts) throws Exception {
        GroupRequest req = this.cast(dests, msg, opts, true);
        return req != null ? req.getNow(null) : null;
    }

    public <T> CompletableFuture<RspList<T>> castMessageWithFuture(Collection<Address> dests, Message msg, RequestOptions opts) throws Exception {
        return this.cast(dests, msg, opts, false);
    }

    protected <T> GroupRequest<T> cast(Collection<Address> dests, Message msg, RequestOptions options, boolean block_for_results) throws Exception {
        if (options == null) {
            this.log.warn("request options were null, using default of sync");
            options = RequestOptions.SYNC();
        }
        List<Address> real_dests = dests != null ? (List)dests.stream().filter(dest -> dest instanceof SiteAddress || this.members.contains(dest)).collect(ArrayList::new, (list, dest) -> {
            if (!list.contains(dest)) {
                list.add(dest);
            }
        }, (l, r) -> {}) : new ArrayList<Address>(this.members);
        JChannel tmp = this.channel;
        if (tmp != null && tmp.getDiscardOwnMessages() || options.transientFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
            if (this.local_addr == null) {
                this.local_addr = tmp != null ? tmp.getAddress() : null;
            }
            real_dests.remove(this.local_addr);
        }
        if (options.hasExclusionList()) {
            Stream.of(options.exclusionList()).forEach(real_dests::remove);
        }
        if (real_dests.isEmpty()) {
            this.log.trace("destination list is empty, won't send message");
            return empty_group_request;
        }
        if (options.mode() == ResponseMode.GET_NONE) {
            this.corr.sendMulticastRequest(real_dests, msg, null, options);
            return null;
        }
        GroupRequest req = new GroupRequest(this.corr, real_dests, options);
        req.execute(msg, block_for_results);
        return req;
    }

    public <T> T sendMessage(Message msg, RequestOptions opts) throws Exception {
        UnicastRequest<T> req = this._sendMessage(msg, opts);
        return req != null ? (T)req.execute(msg, true) : null;
    }

    public <T> CompletableFuture<T> sendMessageWithFuture(Message msg, RequestOptions opts) throws Exception {
        UnicastRequest<T> req = this._sendMessage(msg, opts);
        if (req != null) {
            req.execute(msg, false);
        }
        return req;
    }

    @Override
    public Object handle(Message msg) throws Exception {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    @Override
    public void handle(Message request, Response response) throws Exception {
        if (this.req_handler != null) {
            if (this.async_dispatching) {
                this.req_handler.handle(request, response);
            } else {
                Object retval = this.req_handler.handle(request);
                if (response != null) {
                    response.send(retval, false);
                }
            }
            return;
        }
        Object retval = this.handle(request);
        if (response != null) {
            response.send(retval, false);
        }
    }

    protected <T> UnicastRequest<T> _sendMessage(Message msg, RequestOptions opts) throws Exception {
        Address dest = msg.getDest();
        if (dest == null) {
            throw new IllegalArgumentException("message destination is null, cannot send message");
        }
        if (opts == null) {
            this.log.warn("request options were null, using default of sync");
            opts = RequestOptions.SYNC();
        }
        if (opts.mode() == ResponseMode.GET_NONE) {
            this.corr.sendUnicastRequest(msg, null, opts);
            return null;
        }
        return new UnicastRequest(this.corr, dest, opts);
    }

    protected Object handleUpEvent(Event evt) throws Exception {
        switch (evt.getType()) {
            case 17: {
                ByteArrayOutputStream output;
                byte[] tmp_state = null;
                if (this.receiver != null && this.getState(output = new ByteArrayOutputStream(1024))) {
                    tmp_state = output.toByteArray();
                }
                return new StateTransferInfo(null, 0L, tmp_state);
            }
            case 20: {
                StateTransferResult result;
                if (this.receiver == null || !(result = (StateTransferResult)evt.getArg()).hasBuffer()) break;
                ByteArrayInputStream input = new ByteArrayInputStream(result.getBuffer());
                this.setState(input);
                break;
            }
            case 72: {
                OutputStream os = (OutputStream)evt.getArg();
                this.getState(os);
                break;
            }
            case 71: {
                InputStream is = (InputStream)evt.getArg();
                this.setState(is);
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                List<Address> new_mbrs = v.getMembers();
                this.setMembers(new_mbrs);
                if (this.receiver == null) break;
                this.receiver.viewAccepted(v);
                break;
            }
            case 10: {
                if (this.receiver == null) break;
                this.receiver.block();
                break;
            }
            case 75: {
                if (this.receiver == null) break;
                this.receiver.unblock();
            }
        }
        return null;
    }

    protected boolean getState(OutputStream out) throws Exception {
        if (this.receiver == null || out == null) {
            return false;
        }
        try {
            this.receiver.getState(out);
            return true;
        }
        catch (UnsupportedOperationException un) {
            return false;
        }
    }

    protected boolean setState(InputStream in) throws Exception {
        if (this.receiver == null || in == null) {
            return false;
        }
        try {
            this.receiver.setState(in);
            return true;
        }
        catch (UnsupportedOperationException un) {
            return false;
        }
    }

    @Override
    public void channelDisconnected(JChannel channel) {
        this.stop();
    }

    @Override
    public void channelClosed(JChannel channel) {
        this.stop();
    }

    static {
        empty_group_request.complete(empty_rsplist);
    }

    class ProtocolAdapter
    extends Protocol
    implements UpHandler {
        ProtocolAdapter() {
        }

        @Override
        public String getName() {
            return "MessageDispatcher";
        }

        @Override
        public <T extends Protocol> T setAddress(Address addr) {
            this.local_addr = addr;
            MessageDispatcher.this.local_addr = addr;
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.setLocalAddress(addr);
            }
            return (T)this;
        }

        @Override
        public UpHandler setLocalAddress(Address a) {
            this.setAddress(a);
            return this;
        }

        @Override
        public Object up(Event evt) {
            if (MessageDispatcher.this.corr != null && !MessageDispatcher.this.corr.receive(evt)) {
                try {
                    return MessageDispatcher.this.handleUpEvent(evt);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            return null;
        }

        @Override
        public Object up(Message msg) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveMessage(msg);
            }
            return null;
        }

        @Override
        public void up(MessageBatch batch) {
            if (MessageDispatcher.this.corr == null) {
                return;
            }
            MessageDispatcher.this.corr.receiveMessageBatch(batch);
        }

        @Override
        public Object down(Event evt) {
            return MessageDispatcher.this.channel != null ? MessageDispatcher.this.channel.down(evt) : null;
        }

        @Override
        public Object down(Message msg) {
            if (MessageDispatcher.this.channel != null) {
                if (!MessageDispatcher.this.channel.isConnected() && !MessageDispatcher.this.channel.isConnecting()) {
                    throw new IllegalStateException("channel is not connected");
                }
                return MessageDispatcher.this.channel.down(msg);
            }
            return null;
        }
    }
}

