/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import org.keycloak.config.ConfigSupportLevel;

public enum OptionCategory {
    CACHE("Cache", 10, ConfigSupportLevel.SUPPORTED),
    STORAGE("Storage", 15, ConfigSupportLevel.EXPERIMENTAL),
    DATABASE("Database", 20, ConfigSupportLevel.SUPPORTED),
    TRANSACTION("Transaction", 30, ConfigSupportLevel.SUPPORTED),
    FEATURE("Feature", 40, ConfigSupportLevel.SUPPORTED),
    HOSTNAME("Hostname", 50, ConfigSupportLevel.SUPPORTED),
    HTTP("HTTP/TLS", 60, ConfigSupportLevel.SUPPORTED),
    HEALTH("Health", 70, ConfigSupportLevel.SUPPORTED),
    METRICS("Metrics", 80, ConfigSupportLevel.SUPPORTED),
    PROXY("Proxy", 90, ConfigSupportLevel.SUPPORTED),
    VAULT("Vault", 100, ConfigSupportLevel.SUPPORTED),
    LOGGING("Logging", 110, ConfigSupportLevel.SUPPORTED),
    SECURITY("Security", 120, ConfigSupportLevel.SUPPORTED),
    EXPORT("Export", 130, ConfigSupportLevel.SUPPORTED),
    IMPORT("Import", 140, ConfigSupportLevel.SUPPORTED),
    GENERAL("General", 999, ConfigSupportLevel.SUPPORTED);

    private final String heading;
    private final int order;
    private final ConfigSupportLevel supportLevel;

    private OptionCategory(String heading, int order, ConfigSupportLevel supportLevel) {
        this.order = order;
        this.supportLevel = supportLevel;
        this.heading = this.getHeadingBySupportLevel(heading);
    }

    public String getHeading() {
        return this.heading;
    }

    public int getOrder() {
        return this.order;
    }

    public ConfigSupportLevel getSupportLevel() {
        return this.supportLevel;
    }

    private String getHeadingBySupportLevel(String heading) {
        if (this.supportLevel.equals((Object)ConfigSupportLevel.EXPERIMENTAL)) {
            heading = (String)heading + " (Experimental)";
        }
        if (this.supportLevel.equals((Object)ConfigSupportLevel.PREVIEW)) {
            heading = (String)heading + " (Preview)";
        }
        return heading;
    }
}

