/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.device;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.models.OAuth2DeviceUserCodeModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpoint;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.grants.device.clientpolicy.context.DeviceTokenRequestContext;
import org.keycloak.protocol.oidc.grants.device.clientpolicy.context.DeviceTokenResponseContext;
import org.keycloak.protocol.oidc.grants.device.endpoints.DeviceEndpoint;
import org.keycloak.protocol.oidc.utils.PkceUtils;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionCrossDCManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.LockObjectsForModification;

public class DeviceGrantType {
    public static final String OAUTH2_DEVICE_VERIFIED_USER_CODE = "OAUTH2_DEVICE_VERIFIED_USER_CODE";
    public static final String OAUTH2_DEVICE_USER_CODE = "device_user_code";
    public static final String OAUTH2_USER_CODE_VERIFY = "device/verify";
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    private KeycloakSession session;
    private TokenEndpoint tokenEndpoint;
    private final RealmModel realm;
    private final EventBuilder event;
    private Cors cors;

    public static UriBuilder oauth2DeviceVerificationUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return baseUriBuilder.path(RealmsResource.class).path("{realm}").path("device");
    }

    public static URI realmOAuth2DeviceVerificationAction(URI baseUri, String realmName) {
        return UriBuilder.fromUri((URI)baseUri).path(RealmsResource.class).path("{realm}").path("device").build(new Object[]{realmName});
    }

    public static UriBuilder oauth2DeviceAuthUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "auth").path(AuthorizationEndpoint.class, "authorizeDevice").path(DeviceEndpoint.class, "handleDeviceRequest");
    }

    public static UriBuilder oauth2DeviceVerificationCompletedUrl(UriInfo baseUri) {
        return baseUri.getBaseUriBuilder().path(RealmsResource.class).path("{realm}").path("device").path("status");
    }

    public static Response denyOAuth2DeviceAuthorization(AuthenticationSessionModel authSession, LoginProtocol.Error error, KeycloakSession session) {
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        KeycloakUriInfo uri = context.getUri();
        UriBuilder uriBuilder = DeviceGrantType.oauth2DeviceVerificationCompletedUrl((UriInfo)uri);
        String errorType = "server_error";
        if (error == LoginProtocol.Error.CONSENT_DENIED) {
            String verifiedUserCode = authSession.getClientNote(OAUTH2_DEVICE_VERIFIED_USER_CODE);
            errorType = !DeviceGrantType.denyUserCode(session, realm, verifiedUserCode) ? "expired_token" : "access_denied";
        }
        return Response.status((int)302).location(uriBuilder.queryParam("error", new Object[]{errorType}).build(new Object[]{realm.getName()})).build();
    }

    public static Response approveOAuth2DeviceAuthorization(AuthenticationSessionModel authSession, AuthenticatedClientSessionModel clientSession, KeycloakSession session) {
        String userSessionId;
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        KeycloakUriInfo uriInfo = context.getUri();
        UriBuilder uriBuilder = DeviceGrantType.oauth2DeviceVerificationCompletedUrl((UriInfo)uriInfo);
        String verifiedUserCode = authSession.getClientNote(OAUTH2_DEVICE_VERIFIED_USER_CODE);
        if (!DeviceGrantType.approveUserCode(session, realm, verifiedUserCode, userSessionId = clientSession.getUserSession().getId(), null)) {
            return Response.status((int)302).location(uriBuilder.queryParam("error", new Object[]{"expired_token"}).build(new Object[]{realm.getName()})).build();
        }
        DeviceGrantType.removeDeviceByUserCode(session, realm, verifiedUserCode);
        return Response.status((int)302).location(uriBuilder.build(new Object[]{realm.getName()})).build();
    }

    public static boolean isOAuth2DeviceVerificationFlow(AuthenticationSessionModel authSession) {
        String flow = authSession.getClientNote(OAUTH2_DEVICE_VERIFIED_USER_CODE);
        return flow != null;
    }

    public static OAuth2DeviceCodeModel getDeviceByDeviceCode(KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event, String deviceCode) {
        OAuth2DeviceCodeModel deviceCodeModel;
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        Map notes = singleUseStore.get(OAuth2DeviceCodeModel.createKey((String)deviceCode));
        OAuth2DeviceCodeModel oAuth2DeviceCodeModel = deviceCodeModel = notes != null ? OAuth2DeviceCodeModel.fromCache((RealmModel)realm, (String)deviceCode, (Map)notes) : null;
        if (deviceCodeModel != null && !client.getClientId().equals(deviceCodeModel.getClientId())) {
            event.error("invalid_oauth2_device_code");
            throw new ErrorResponseException("invalid_grant", "unauthorized client", Response.Status.BAD_REQUEST);
        }
        return deviceCodeModel;
    }

    public static void removeDeviceByDeviceCode(KeycloakSession session, String deviceCode) {
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        singleUseStore.remove(OAuth2DeviceCodeModel.createKey((String)deviceCode));
    }

    public static void removeDeviceByUserCode(KeycloakSession session, RealmModel realm, String userCode) {
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        singleUseStore.remove(OAuth2DeviceUserCodeModel.createKey((RealmModel)realm, (String)userCode));
    }

    public static boolean isPollingAllowed(KeycloakSession session, OAuth2DeviceCodeModel deviceCodeModel) {
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        return singleUseStore.putIfAbsent(deviceCodeModel.serializePollingKey(), (long)deviceCodeModel.getPollingInterval());
    }

    public static boolean approveUserCode(KeycloakSession session, RealmModel realm, String userCode, String userSessionId, Map<String, String> additionalParams) {
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        OAuth2DeviceCodeModel deviceCodeModel = DeviceEndpoint.getDeviceByUserCode(session, realm, userCode);
        if (deviceCodeModel != null) {
            OAuth2DeviceCodeModel approvedDeviceCode = deviceCodeModel.approve(userSessionId, additionalParams);
            return singleUseStore.replace(approvedDeviceCode.serializeKey(), approvedDeviceCode.toMap());
        }
        return false;
    }

    public static boolean denyUserCode(KeycloakSession session, RealmModel realm, String userCode) {
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)session.getProvider(SingleUseObjectProvider.class);
        OAuth2DeviceCodeModel deviceCodeModel = DeviceEndpoint.getDeviceByUserCode(session, realm, userCode);
        if (deviceCodeModel != null) {
            OAuth2DeviceCodeModel deniedDeviceCode = deviceCodeModel.deny();
            return singleUseStore.replace(deniedDeviceCode.serializeKey(), deniedDeviceCode.toMap());
        }
        return false;
    }

    public DeviceGrantType(MultivaluedMap<String, String> formParams, ClientModel client, KeycloakSession session, TokenEndpoint tokenEndpoint, RealmModel realm, EventBuilder event, Cors cors) {
        this.formParams = formParams;
        this.client = client;
        this.session = session;
        this.tokenEndpoint = tokenEndpoint;
        this.realm = realm;
        this.event = event;
        this.cors = cors;
    }

    public Response oauth2DeviceFlow() {
        if (!this.realm.getOAuth2DeviceConfig().isOAuth2DeviceAuthorizationGrantEnabled(this.client)) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Client not allowed OAuth 2.0 Device Authorization Grant", Response.Status.BAD_REQUEST);
        }
        String deviceCode = (String)this.formParams.getFirst((Object)"device_code");
        if (deviceCode == null) {
            this.event.error("invalid_oauth2_device_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Missing parameter: device_code", Response.Status.BAD_REQUEST);
        }
        OAuth2DeviceCodeModel deviceCodeModel = DeviceGrantType.getDeviceByDeviceCode(this.session, this.realm, this.client, this.event, deviceCode);
        if (deviceCodeModel == null) {
            this.event.error("invalid_oauth2_device_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Device code not valid", Response.Status.BAD_REQUEST);
        }
        if (deviceCodeModel.isExpired()) {
            this.event.error("expired_oauth2_device_code");
            throw new CorsErrorResponseException(this.cors, "expired_token", "Device code is expired", Response.Status.BAD_REQUEST);
        }
        if (!DeviceGrantType.isPollingAllowed(this.session, deviceCodeModel)) {
            this.event.error("slow_down");
            throw new CorsErrorResponseException(this.cors, "slow_down", "Slow down", Response.Status.BAD_REQUEST);
        }
        if (deviceCodeModel.isDenied()) {
            this.event.error("access_denied");
            throw new CorsErrorResponseException(this.cors, "access_denied", "The end user denied the authorization request", Response.Status.BAD_REQUEST);
        }
        if (deviceCodeModel.isPending()) {
            throw new CorsErrorResponseException(this.cors, "authorization_pending", "The authorization request is still pending", Response.Status.BAD_REQUEST);
        }
        String codeVerifier = (String)this.formParams.getFirst((Object)"code_verifier");
        String codeChallenge = deviceCodeModel.getCodeChallenge();
        String codeChallengeMethod = deviceCodeModel.getCodeChallengeMethod();
        if (codeChallengeMethod != null && !codeChallengeMethod.isEmpty()) {
            PkceUtils.checkParamsForPkceEnforcedClient(codeVerifier, codeChallenge, codeChallengeMethod, null, null, this.event, this.cors);
        } else {
            PkceUtils.checkParamsForPkceNotEnforcedClient(codeVerifier, codeChallenge, codeChallengeMethod, null, null, this.event, this.cors);
        }
        String userSessionId = deviceCodeModel.getUserSessionId();
        this.event.detail("code_id", userSessionId);
        this.event.session(userSessionId);
        UserSessionModel userSession = new UserSessionCrossDCManager(this.session).getUserSessionWithClient(this.realm, userSessionId, this.client.getId());
        if (userSession == null && (userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.session, () -> this.session.sessions().getUserSession(this.realm, userSessionId))) == null) {
            throw new CorsErrorResponseException(this.cors, "authorization_pending", "The authorization request is verified but can not lookup the user session yet", Response.Status.BAD_REQUEST);
        }
        DeviceGrantType.removeDeviceByDeviceCode(this.session, deviceCode);
        UserModel user = userSession.getUser();
        if (user == null) {
            this.event.error("user_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User not found", Response.Status.BAD_REQUEST);
        }
        this.event.user(userSession.getUser());
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User disabled", Response.Status.BAD_REQUEST);
        }
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(this.client.getId());
        if (!this.client.getClientId().equals(clientSession.getClient().getClientId())) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Auth error", Response.Status.BAD_REQUEST);
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            this.event.error("user_session_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Session not active", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new DeviceTokenRequestContext(deviceCodeModel, this.formParams));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, "invalid_grant", cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        String scopeParam = deviceCodeModel.getScope();
        if (!TokenManager.verifyConsentStillAvailable(this.session, user, this.client, TokenManager.getRequestedClientScopes(scopeParam, this.client))) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", "Client no longer has requested consent from user", Response.Status.BAD_REQUEST);
        }
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, scopeParam, this.session);
        clientSessionCtx.setAttribute("nonce", deviceCodeModel.getNonce());
        return this.tokenEndpoint.createTokenResponse(user, userSession, clientSessionCtx, scopeParam, false, s -> new DeviceTokenResponseContext(deviceCodeModel, this.formParams, clientSession, (TokenManager.AccessTokenResponseBuilder)s));
    }
}

