/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionNoteDescriptor;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenResponseMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public class UserSessionNoteMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
OIDCAccessTokenResponseMapper,
UserInfoTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-usersessionmodel-note-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Session Note";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a custom user session note to a token claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        String noteName = (String)mappingModel.getConfig().get("user.session.note");
        String noteValue = userSession.getNote(noteName);
        if (noteValue == null) {
            return;
        }
        OIDCAttributeMapperHelper.mapClaim(token, mappingModel, (Object)noteValue);
    }

    @Override
    protected void setClaim(AccessTokenResponse accessTokenResponse, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        String noteName = (String)mappingModel.getConfig().get("user.session.note");
        String noteValue = userSession.getNote(noteName);
        if (noteValue == null) {
            return;
        }
        OIDCAttributeMapperHelper.mapClaim(accessTokenResponse, mappingModel, (Object)noteValue);
    }

    public static ProtocolMapperModel createClaimMapper(String name, String userSessionNote, String tokenClaimName, String jsonType, boolean accessToken, boolean idToken) {
        return UserSessionNoteMapper.createClaimMapper(name, userSessionNote, tokenClaimName, jsonType, accessToken, idToken, false);
    }

    public static ProtocolMapperModel createClaimMapper(String name, String userSessionNote, String tokenClaimName, String jsonType, boolean accessToken, boolean idToken, boolean userInfo) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("user.session.note", userSessionNote);
        config.put("claim.name", tokenClaimName);
        config.put("jsonType.label", jsonType);
        if (accessToken) {
            config.put("access.token.claim", "true");
        }
        if (idToken) {
            config.put("id.token.claim", "true");
        }
        if (userInfo) {
            config.put("userinfo.token.claim", "true");
        }
        mapper.setConfig(config);
        return mapper;
    }

    public static ProtocolMapperModel createUserSessionNoteMapper(UserSessionNoteDescriptor userSessionNoteDescriptor) {
        return UserSessionNoteMapper.createClaimMapper(userSessionNoteDescriptor.getDisplayName(), userSessionNoteDescriptor.toString(), userSessionNoteDescriptor.getTokenClaim(), "String", true, true);
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("user.session.note");
        property.setLabel("userSession.modelNote.label");
        property.setHelpText("userSession.modelNote.tooltip");
        property.setType("String");
        configProperties.add(property);
        OIDCAttributeMapperHelper.addAttributeConfig(configProperties, UserSessionNoteMapper.class);
    }
}

