/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.lockservice;

import liquibase.exception.DatabaseException;
import liquibase.lockservice.StandardLockService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.jboss.logging.Logger;

public class KeycloakLockService
extends StandardLockService {
    private static final Logger log = Logger.getLogger(KeycloakLockService.class);

    public int getPriority() {
        return super.getPriority() + 1;
    }

    protected boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        boolean originalReturnValue = super.hasDatabaseChangeLogLockTable();
        if (originalReturnValue) {
            Table lockTable = (Table)new Table().setName(this.database.getDatabaseChangeLogLockTableName()).setSchema(new Schema(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName()));
            SnapshotGeneratorFactory instance = SnapshotGeneratorFactory.getInstance();
            try {
                DatabaseSnapshot snapshot = instance.createSnapshot(lockTable.getSchema().toCatalogAndSchema(), this.database, new SnapshotControl(this.database, false, new Class[]{Table.class, PrimaryKey.class}).setWarnIfObjectNotFound(false));
                Table lockTableFromSnapshot = (Table)snapshot.get((DatabaseObject)lockTable);
                if (lockTableFromSnapshot == null) {
                    throw new RuntimeException("DATABASECHANGELOGLOCK not found, although Liquibase claims it exists.");
                }
                if (lockTableFromSnapshot.getPrimaryKey() == null) {
                    log.warn((Object)"Primary key not found - table creation not complete yet.");
                    return false;
                }
            }
            catch (InvalidExampleException e) {
                throw new RuntimeException(e);
            }
        }
        return originalReturnValue;
    }
}

