/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.server.core.admin.AdminServerTask;

public class CacheUpdateConfigurationAttributeTask
extends AdminServerTask<Void> {
    private static final Set<String> PARAMETERS = Set.of("name", "attribute", "value");

    @Override
    public String getTaskContextName() {
        return "cache";
    }

    @Override
    public String getTaskOperationName() {
        return "updateConfigurationAttribute";
    }

    public Set<String> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected Void execute(EmbeddedCacheManager cacheManager, Map<String, List<String>> parameters, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        String cacheName = this.requireParameter(parameters, "name");
        String attributeName = this.requireParameter(parameters, "attribute");
        String attributeValue = this.requireParameter(parameters, "value");
        Cache cache = cacheManager.getCache(cacheName);
        Configuration config = cache.getCacheConfiguration();
        Attribute attribute = config.findAttribute(attributeName);
        attribute.fromString(attributeValue);
        flags.add(CacheContainerAdmin.AdminFlag.UPDATE);
        ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(flags)).getOrCreateCache(cacheName, config);
        return null;
    }
}

