/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import io.netty.handler.ipfilter.IpFilterRuleType;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.AbstractProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.IpFilterConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.transport.IpSubnetFilterRule;

public class IpFilterConfigurationBuilder<T extends ProtocolServerConfiguration, S extends ProtocolServerConfigurationChildBuilder<T, S>>
extends AbstractProtocolServerConfigurationChildBuilder<T, S>
implements Builder<IpFilterConfiguration> {
    private final List<IpSubnetFilterRule> rules = new ArrayList<IpSubnetFilterRule>();

    public IpFilterConfigurationBuilder(ProtocolServerConfigurationChildBuilder<T, S> builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public IpFilterConfigurationBuilder<T, S> allowFrom(String rule) {
        this.rules.add(new IpSubnetFilterRule(rule, IpFilterRuleType.ACCEPT));
        return this;
    }

    public IpFilterConfigurationBuilder<T, S> rejectFrom(String rule) {
        this.rules.add(new IpSubnetFilterRule(rule, IpFilterRuleType.REJECT));
        return this;
    }

    public IpFilterConfiguration create() {
        return new IpFilterConfiguration(this.rules);
    }

    public IpFilterConfigurationBuilder<T, S> read(IpFilterConfiguration template) {
        this.rules.clear();
        this.rules.addAll(template.rules());
        return this;
    }

    public S self() {
        return (S)this;
    }
}

