/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.util.ContainerRuntimeUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class NativeImageBuildLocalContainerRunner
extends NativeImageBuildContainerRunner {
    private static final Logger LOGGER = Logger.getLogger((String)NativeImageBuildLocalContainerRunner.class.getName());

    public NativeImageBuildLocalContainerRunner(NativeConfig nativeConfig, Path outputDir) {
        super(nativeConfig, outputDir);
        if (SystemUtils.IS_OS_LINUX) {
            ArrayList<String> containerRuntimeArgs = new ArrayList<String>(Arrays.asList(this.baseContainerRuntimeArgs));
            if (this.containerRuntime == ContainerRuntimeUtil.ContainerRuntime.DOCKER && this.containerRuntime.isRootless()) {
                Collections.addAll(containerRuntimeArgs, "--user", String.valueOf(0));
            } else {
                String uid = LinuxIDUtil.getLinuxID("-ur");
                String gid = LinuxIDUtil.getLinuxID("-gr");
                if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                    Collections.addAll(containerRuntimeArgs, "--user", uid + ":" + gid);
                    if (this.containerRuntime == ContainerRuntimeUtil.ContainerRuntime.PODMAN && this.containerRuntime.isRootless()) {
                        containerRuntimeArgs.add("--userns=keep-id");
                    }
                }
            }
            this.baseContainerRuntimeArgs = containerRuntimeArgs.toArray(this.baseContainerRuntimeArgs);
        }
    }

    @Override
    protected List<String> getContainerRuntimeBuildArgs() {
        List<String> containerRuntimeArgs = super.getContainerRuntimeBuildArgs();
        String volumeOutputPath = this.outputPath;
        if (SystemUtils.IS_OS_WINDOWS) {
            volumeOutputPath = FileUtil.translateToVolumePath(volumeOutputPath);
        }
        String selinuxBindOption = ":z";
        if (SystemUtils.IS_OS_MAC && ContainerRuntimeUtil.detectContainerRuntime() == ContainerRuntimeUtil.ContainerRuntime.PODMAN) {
            selinuxBindOption = "";
        }
        Collections.addAll(containerRuntimeArgs, "-v", volumeOutputPath + ":/project" + selinuxBindOption);
        return containerRuntimeArgs;
    }
}

