/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.logging.Log;

public class CounterManagerConfigurationBuilder
implements Builder<CounterManagerConfiguration> {
    private static final CounterManagerConfiguration DEFAULT = new CounterManagerConfigurationBuilder(null).create();
    private final AttributeSet attributes = CounterManagerConfiguration.attributeDefinitionSet();
    private final List<CounterConfigurationBuilder<?, ?>> defaultCounters = new ArrayList(2);
    private final GlobalConfigurationBuilder builder;

    public CounterManagerConfigurationBuilder(GlobalConfigurationBuilder builder) {
        this.builder = builder;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public static CounterManagerConfiguration defaultConfiguration() {
        return DEFAULT;
    }

    public CounterManagerConfigurationBuilder numOwner(int numOwners) {
        this.attributes.attribute(CounterManagerConfiguration.NUM_OWNERS).set((Object)numOwners);
        return this;
    }

    public CounterManagerConfigurationBuilder reliability(Reliability reliability) {
        this.attributes.attribute(CounterManagerConfiguration.RELIABILITY).set((Object)reliability);
        return this;
    }

    public StrongCounterConfigurationBuilder addStrongCounter() {
        StrongCounterConfigurationBuilder builder = new StrongCounterConfigurationBuilder(this);
        this.defaultCounters.add(builder);
        return builder;
    }

    public WeakCounterConfigurationBuilder addWeakCounter() {
        WeakCounterConfigurationBuilder builder = new WeakCounterConfigurationBuilder(this);
        this.defaultCounters.add(builder);
        return builder;
    }

    public void validate() {
        this.attributes.attributes().forEach(Attribute::validate);
        this.defaultCounters.forEach(Builder::validate);
        HashSet<String> counterNames = new HashSet<String>();
        for (CounterConfigurationBuilder<?, ?> builder : this.defaultCounters) {
            if (counterNames.add(builder.name())) continue;
            throw Log.CONTAINER.duplicatedCounterName(builder.name());
        }
    }

    public CounterManagerConfiguration create() {
        HashMap<String, AbstractCounterConfiguration> counters = new HashMap<String, AbstractCounterConfiguration>(this.defaultCounters.size());
        for (CounterConfigurationBuilder<?, ?> builder : this.defaultCounters) {
            counters.put(builder.name(), (AbstractCounterConfiguration)builder.create());
        }
        return new CounterManagerConfiguration(this.attributes.protect(), counters);
    }

    public Builder<?> read(CounterManagerConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public void clearCounters() {
        this.defaultCounters.clear();
    }

    boolean isGlobalStateEnabled() {
        return this.builder.globalState().enabled();
    }

    public List<CounterConfigurationBuilder<?, ?>> counters() {
        return this.defaultCounters;
    }
}

