/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.transaction.TransactionContext;
import org.infinispan.client.hotrod.impl.transaction.TransactionTable;
import org.infinispan.client.hotrod.impl.transaction.entry.TransactionEntry;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.time.TimeService;

public class TransactionalRemoteCacheImpl<K, V>
extends RemoteCacheImpl<K, V> {
    private static final Log log = LogFactory.getLog(TransactionalRemoteCacheImpl.class, Log.class);
    private final boolean forceReturnValue;
    private final boolean recoveryEnabled;
    private final TransactionManager transactionManager;
    private final TransactionTable transactionTable;
    private final Function<K, MetadataValue<V>> remoteGet = this::getWithMetadataNotTracked;
    private final Function<K, byte[]> keyMarshaller = this::keyToBytes;
    private final Function<V, byte[]> valueMarshaller = x$0 -> this.valueToBytes(x$0);

    public TransactionalRemoteCacheImpl(RemoteCacheManager rcm, String name, boolean forceReturnValue, boolean recoveryEnabled, TransactionManager transactionManager, TransactionTable transactionTable, TimeService timeService) {
        super(rcm, name, timeService);
        this.forceReturnValue = forceReturnValue;
        this.recoveryEnabled = recoveryEnabled;
        this.transactionManager = transactionManager;
        this.transactionTable = transactionTable;
    }

    @Override
    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        return txContext == null ? super.removeWithVersionAsync(key, version) : txContext.compute(key, entry -> this.removeEntryIfSameVersion((TransactionEntry<K, V>)entry, version), this.remoteGet);
    }

    @Override
    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        return txContext == null ? super.replaceWithVersionAsync(key, newValue, version, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit) : txContext.compute(key, entry -> this.replaceEntryIfSameVersion((TransactionEntry<K, V>)entry, newValue, version, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit), this.remoteGet);
    }

    @Override
    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        return txContext == null ? super.getWithMetadataAsync(key) : txContext.compute(key, TransactionEntry::toMetadataValue, this.remoteGet);
    }

    private MetadataValue<V> getWithMetadataNotTracked(K key) {
        return Util.await(super.getWithMetadataAsync(key));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        if (txContext == null) {
            return super.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
        map.forEach((key, value) -> txContext.compute(key, (TransactionEntry<K, V> entry) -> this.getAndSetEntry((TransactionEntry<K, V>)entry, (V)value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit)));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        if (txContext == null) {
            return super.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
        if (this.forceReturnValue) {
            return txContext.compute(key, entry -> this.getAndSetEntry((TransactionEntry<K, V>)entry, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit), this.remoteGet);
        }
        return txContext.compute(key, (TransactionEntry<K, V> entry) -> this.getAndSetEntry((TransactionEntry<K, V>)entry, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        return txContext == null ? super.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit) : txContext.compute(key, entry -> this.putEntryIfAbsent((TransactionEntry<K, V>)entry, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit), this.remoteGet);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        return txContext == null ? super.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit) : txContext.compute(key, entry -> this.replaceEntry((TransactionEntry<K, V>)entry, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit), this.remoteGet);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        return txContext == null ? super.replaceAsync(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit) : txContext.compute(key, entry -> this.replaceEntryIfEquals((TransactionEntry<K, V>)entry, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit), this.remoteGet);
    }

    @Override
    public CompletableFuture<Boolean> containsKeyAsync(K key) {
        TransactionContext<K, V> txContext = this.getTransactionContext();
        return txContext == null ? super.containsKeyAsync(key) : txContext.containsKey(key, this.remoteGet);
    }

    @Override
    public boolean containsValue(Object value) {
        TransactionContext txContext = this.getTransactionContext();
        return txContext == null ? super.containsValue(value) : txContext.containsValue(value, () -> super.entrySet(), this.remoteGet);
    }

    @Override
    public CompletableFuture<V> getAsync(Object key) {
        TransactionContext<Object, V> txContext = this.getTransactionContext();
        return txContext == null ? super.getAsync(key) : txContext.compute(key, TransactionEntry::getValue, this.remoteGet);
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        TransactionContext<Object, V> txContext = this.getTransactionContext();
        if (txContext == null) {
            return super.removeAsync(key);
        }
        if (this.forceReturnValue) {
            return txContext.compute(key, this::removeEntry, this.remoteGet);
        }
        return txContext.compute(key, this::removeEntry);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        TransactionContext<Object, V> txContext = this.getTransactionContext();
        return txContext == null ? super.removeAsync(key, value) : txContext.compute(key, entry -> this.removeEntryIfEquals((TransactionEntry<K, V>)entry, value), this.remoteGet);
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    Function<K, byte[]> keyMarshaller() {
        return this.keyMarshaller;
    }

    Function<V, byte[]> valueMarshaller() {
        return this.valueMarshaller;
    }

    private boolean removeEntryIfSameVersion(TransactionEntry<K, V> entry, long version) {
        if (entry.exists() && entry.getVersion() == version) {
            entry.remove();
            return true;
        }
        return false;
    }

    private boolean replaceEntryIfSameVersion(TransactionEntry<K, V> entry, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        if (entry.exists() && entry.getVersion() == version) {
            entry.set(newValue, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
            return true;
        }
        return false;
    }

    private V putEntryIfAbsent(TransactionEntry<K, V> entry, V value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V currentValue = entry.getValue();
        if (currentValue == null) {
            entry.set(value, lifespan, lifespanTimeUnit, maxIdleTime, maxIdleTimeUnit);
        }
        return currentValue;
    }

    private V replaceEntry(TransactionEntry<K, V> entry, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V currentValue = entry.getValue();
        if (currentValue != null) {
            entry.set(value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
        return currentValue;
    }

    private boolean replaceEntryIfEquals(TransactionEntry<K, V> entry, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V currentValue = entry.getValue();
        if (currentValue != null && Objects.deepEquals(currentValue, oldValue)) {
            entry.set(value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
            return true;
        }
        return false;
    }

    private V removeEntry(TransactionEntry<K, V> entry) {
        V oldValue = entry.getValue();
        entry.remove();
        return oldValue;
    }

    private boolean removeEntryIfEquals(TransactionEntry<K, V> entry, Object value) {
        V oldValue = entry.getValue();
        if (oldValue != null && Objects.deepEquals(oldValue, value)) {
            entry.remove();
            return true;
        }
        return false;
    }

    private V getAndSetEntry(TransactionEntry<K, V> entry, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V oldValue = entry.getValue();
        entry.set(value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return oldValue;
    }

    private TransactionContext<K, V> getTransactionContext() {
        this.assertRemoteCacheManagerIsStarted();
        Transaction tx = this.getRunningTransaction();
        if (tx != null) {
            return this.transactionTable.enlist(this, tx);
        }
        return null;
    }

    private Transaction getRunningTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            log.debug("Exception in getRunningTransaction().", e);
            return null;
        }
    }
}

