/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.SniConfiguration;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;

public class SniConfigurationBuilder
implements Builder<SniConfiguration> {
    private final AttributeSet attributes;
    private final SslConfigurationBuilder ssl;

    SniConfigurationBuilder(SslConfigurationBuilder ssl) {
        this.ssl = ssl;
        this.attributes = SniConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SniConfigurationBuilder realm(String name) {
        this.attributes.attribute(SniConfiguration.SECURITY_REALM).set((Object)name);
        return this;
    }

    public SniConfigurationBuilder host(String name) {
        this.attributes.attribute(SniConfiguration.HOST_NAME).set((Object)name);
        this.ssl.sniHostName(name);
        return this;
    }

    public SniConfigurationBuilder sslContext(SSLContext sslContext) {
        this.ssl.sslContext(sslContext);
        return this;
    }

    public SniConfigurationBuilder sslContext(Supplier<SSLContext> sslContext) {
        this.ssl.sslContext(sslContext);
        return this;
    }

    public SniConfiguration create() {
        return new SniConfiguration(this.attributes.protect());
    }

    public SniConfigurationBuilder read(SniConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

