/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.lock.delegate;

import java.util.UUID;
import javax.persistence.EntityManager;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.lock.MapLockEntity;
import org.keycloak.models.map.lock.MapLockEntityFields;
import org.keycloak.models.map.storage.jpa.JpaDelegateProvider;
import org.keycloak.models.map.storage.jpa.lock.entity.JpaLockEntity;

public class JpaLockDelegateProvider
extends JpaDelegateProvider<JpaLockEntity>
implements DelegateProvider<MapLockEntity> {
    private final EntityManager em;

    public JpaLockDelegateProvider(JpaLockEntity delegate, EntityManager em) {
        super(delegate);
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapLockEntity getDelegate(boolean isRead, Enum<? extends EntityField<MapLockEntity>> field, Object ... parameters) {
        if (((JpaLockEntity)this.getDelegate()).isMetadataInitialized()) {
            return (MapLockEntity)this.getDelegate();
        }
        if (isRead) {
            if (!(field instanceof MapLockEntityFields)) throw new IllegalStateException("Not a valid lock field: " + field);
            switch ((MapLockEntityFields)field) {
                case ID: 
                case NAME: {
                    return (MapLockEntity)this.getDelegate();
                }
            }
            this.setDelegate((JpaLockEntity)this.em.find(JpaLockEntity.class, (Object)UUID.fromString(((JpaLockEntity)this.getDelegate()).getId())));
            return (MapLockEntity)this.getDelegate();
        } else {
            this.setDelegate((JpaLockEntity)this.em.find(JpaLockEntity.class, (Object)UUID.fromString(((JpaLockEntity)this.getDelegate()).getId())));
        }
        return (MapLockEntity)this.getDelegate();
    }
}

