/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.AuthorizationStoreFactory;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.MapAuthorizationStore;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.InvalidationHandler;

public class MapAuthorizationStoreFactory
implements AmphibianProviderFactory<StoreFactory>,
AuthorizationStoreFactory,
EnvironmentDependentProviderFactory,
InvalidationHandler {
    public static final String PROVIDER_ID = "map";
    private Config.Scope storageConfigScope;
    private final String uniqueKey = MapAuthorizationStoreFactory.class.getName() + AbstractMapProviderFactory.uniqueCounter.incrementAndGet();

    public StoreFactory create(KeycloakSession session) {
        MapAuthorizationStore authzStore = (MapAuthorizationStore)session.getAttribute(this.uniqueKey, MapAuthorizationStore.class);
        if (authzStore != null) {
            return authzStore;
        }
        MapStorageProvider mapStorageProvider = (MapStorageProvider)AbstractMapProviderFactory.getProviderFactoryOrComponentFactory(session, this.storageConfigScope).create(session);
        AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        MapStorage<MapPermissionTicketEntity, PermissionTicket> permissionTicketStore = mapStorageProvider.getMapStorage(PermissionTicket.class, new MapStorageProviderFactory.Flag[0]);
        MapStorage<MapPolicyEntity, Policy> policyStore = mapStorageProvider.getMapStorage(Policy.class, new MapStorageProviderFactory.Flag[0]);
        MapStorage<MapResourceServerEntity, ResourceServer> resourceServerStore = mapStorageProvider.getMapStorage(ResourceServer.class, new MapStorageProviderFactory.Flag[0]);
        MapStorage<MapResourceEntity, Resource> resourceStore = mapStorageProvider.getMapStorage(Resource.class, new MapStorageProviderFactory.Flag[0]);
        MapStorage<MapScopeEntity, Scope> scopeStore = mapStorageProvider.getMapStorage(Scope.class, new MapStorageProviderFactory.Flag[0]);
        authzStore = new MapAuthorizationStore(permissionTicketStore, policyStore, resourceServerStore, resourceStore, scopeStore, provider);
        session.setAttribute(this.uniqueKey, (Object)authzStore);
        return authzStore;
    }

    public void init(Config.Scope config) {
        this.storageConfigScope = config.scope(new String[]{"storage"});
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Authorization store provider";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public void invalidate(KeycloakSession session, InvalidationHandler.InvalidableObjectType type, Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE) {
            MapAuthorizationStore authorizationStore = (MapAuthorizationStore)session.getProvider(StoreFactory.class);
            RealmModel realm = (RealmModel)params[0];
            authorizationStore.getScopeStore().preRemove(realm);
            authorizationStore.getPolicyStore().preRemove(realm);
            authorizationStore.getResourceStore().preRemove(realm);
            authorizationStore.getPermissionTicketStore().preRemove(realm);
            authorizationStore.getResourceServerStore().preRemove(realm);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.RESOURCE_SERVER_BEFORE_REMOVE) {
            MapAuthorizationStore authorizationStore = (MapAuthorizationStore)session.getProvider(StoreFactory.class);
            RealmModel realm = (RealmModel)params[0];
            ResourceServer resourceServer = (ResourceServer)params[1];
            authorizationStore.getScopeStore().preRemove(realm, resourceServer);
            authorizationStore.getPolicyStore().preRemove(realm, resourceServer);
            authorizationStore.getResourceStore().preRemove(realm, resourceServer);
            authorizationStore.getPermissionTicketStore().preRemove(realm, resourceServer);
        }
    }
}

