/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.provider.Provider;

public class SessionAttributesUtils {
    private static final AtomicInteger COUNTER_TX = new AtomicInteger();

    public static int grabNewFactoryIdentifier() {
        return COUNTER_TX.getAndIncrement();
    }

    public static <T extends Provider> T createProviderIfAbsent(KeycloakSession session, int factoryIdentifier, Class<T> providerClass, Function<KeycloakSession, T> createNew) {
        String uniqueKey = providerClass.getName() + factoryIdentifier;
        Provider provider = (Provider)session.getAttribute(uniqueKey, providerClass);
        if (provider != null) {
            return (T)provider;
        }
        provider = (Provider)createNew.apply(session);
        session.setAttribute(uniqueKey, (Object)provider);
        return (T)provider;
    }

    public static <V extends AbstractEntity & UpdatableEntity, M, T extends MapStorage<V, M>> T createMapStorageIfAbsent(KeycloakSession session, Class<? extends MapStorageProvider> providerType, Class<M> modelType, int factoryId, Supplier<T> createNew) {
        String sessionAttributeName = providerType.getName() + "-" + (modelType != null ? modelType.getName() : "") + "-" + factoryId;
        MapStorage sessionTransaction = (MapStorage)session.getAttribute(sessionAttributeName, MapStorage.class);
        if (sessionTransaction == null) {
            sessionTransaction = (MapStorage)createNew.get();
            session.setAttribute(sessionAttributeName, (Object)sessionTransaction);
        }
        return (T)sessionTransaction;
    }
}

