/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.session;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.provider.Provider;

public interface UserSessionPersisterProvider
extends Provider {
    public void createUserSession(UserSessionModel var1, boolean var2);

    public void createClientSession(AuthenticatedClientSessionModel var1, boolean var2);

    public void removeUserSession(String var1, boolean var2);

    public void removeClientSession(String var1, String var2, boolean var3);

    public void onRealmRemoved(RealmModel var1);

    public void onClientRemoved(RealmModel var1, ClientModel var2);

    public void onUserRemoved(RealmModel var1, UserModel var2);

    public void updateLastSessionRefreshes(RealmModel var1, int var2, Collection<String> var3, boolean var4);

    public void removeExpired(RealmModel var1);

    public UserSessionModel loadUserSession(RealmModel var1, String var2, boolean var3);

    public Stream<UserSessionModel> loadUserSessionsStream(RealmModel var1, UserModel var2, boolean var3, Integer var4, Integer var5);

    public Stream<UserSessionModel> loadUserSessionsStream(RealmModel var1, ClientModel var2, boolean var3, Integer var4, Integer var5);

    @Deprecated
    default public List<UserSessionModel> loadUserSessions(int firstResult, int maxResults, boolean offline, int lastCreatedOn, String lastUserSessionId) {
        return this.loadUserSessionsStream(firstResult, maxResults, offline, lastUserSessionId).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> loadUserSessionsStream(Integer var1, Integer var2, boolean var3, String var4);

    public AuthenticatedClientSessionModel loadClientSession(RealmModel var1, ClientModel var2, UserSessionModel var3, boolean var4);

    public int getUserSessionsCount(boolean var1);

    public int getUserSessionsCount(RealmModel var1, ClientModel var2, boolean var3);

    public Map<String, Long> getUserSessionsCountsByClients(RealmModel var1, boolean var2);
}

