/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.GroupResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.GroupPermissionEvaluator;
import org.keycloak.utils.GroupUtils;
import org.keycloak.utils.SearchQueryUtils;

@Extension(name="x-smallrye-profile-admin", value="")
public class GroupsResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;

    public GroupsResource(RealmModel realm, KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.GROUP);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Groups")
    @Operation(summary="Get group hierarchy.  Only name and ids are returned.")
    public Stream<GroupRepresentation> getGroups(@QueryParam(value="search") String search, @QueryParam(value="q") String searchQuery, @QueryParam(value="exact") @DefaultValue(value="false") Boolean exact, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation, @QueryParam(value="populateHierarchy") @DefaultValue(value="true") boolean populateHierarchy) {
        GroupPermissionEvaluator groupsEvaluator = this.auth.groups();
        groupsEvaluator.requireList();
        Stream stream = null;
        if (Objects.nonNull(searchQuery)) {
            Map<String, String> attributes = SearchQueryUtils.getFields(searchQuery);
            stream = ModelToRepresentation.searchGroupModelsByAttributes((KeycloakSession)this.session, (RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0, (boolean)populateHierarchy, attributes, (Integer)firstResult, (Integer)maxResults);
        } else {
            stream = Objects.nonNull(search) ? ModelToRepresentation.searchForGroupModelByName((KeycloakSession)this.session, (RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0, (String)search.trim(), (Boolean)exact, (Integer)firstResult, (Integer)maxResults) : (Objects.nonNull(firstResult) && Objects.nonNull(maxResults) ? ModelToRepresentation.toGroupModelHierarchy((RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0, (Integer)firstResult, (Integer)maxResults) : this.realm.getTopLevelGroupsStream());
        }
        boolean canViewGlobal = groupsEvaluator.canView();
        return stream.filter(group -> canViewGlobal || groupsEvaluator.canView((GroupModel)group)).map(group -> GroupUtils.toGroupHierarchy(groupsEvaluator, group, search, exact, !briefRepresentation));
    }

    @Path(value="{id}")
    public GroupResource getGroupById(@PathParam(value="id") String id) {
        GroupModel group = this.realm.getGroupById(id);
        if (group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        return new GroupResource(this.realm, group, this.session, this.auth, this.adminEvent);
    }

    @GET
    @NoCache
    @Path(value="count")
    @Produces(value={"application/json"})
    @Tag(name="Groups")
    @Operation(summary="Returns the groups counts.")
    public Map<String, Long> getGroupCount(@QueryParam(value="search") String search, @QueryParam(value="top") @DefaultValue(value="false") boolean onlyTopGroups) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Long results = Objects.nonNull(search) ? this.realm.getGroupsCountByNameContaining(search) : this.realm.getGroupsCount(Boolean.valueOf(onlyTopGroups));
        map.put("count", results);
        return map;
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Groups")
    @Operation(summary="create or add a top level realm groupSet or create child.", description="This will update the group and set the parent if it exists. Create it and set the parent if the group doesn\u2019t exist.")
    public Response addTopLevelGroup(GroupRepresentation rep) {
        this.auth.groups().requireManage();
        Response.ResponseBuilder builder = Response.status((int)204);
        String groupName = rep.getName();
        if (ObjectUtil.isBlank((CharSequence)groupName)) {
            throw ErrorResponse.error("Group name is missing", Response.Status.BAD_REQUEST);
        }
        try {
            if (rep.getId() != null) {
                GroupModel child = this.realm.getGroupById(rep.getId());
                if (child == null) {
                    throw new NotFoundException("Could not find child by id");
                }
                if (child.getParentId() != null) {
                    this.realm.moveGroup(child, null);
                }
                this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri());
            } else {
                GroupModel child = this.realm.createGroup(groupName);
                GroupResource.updateGroup(rep, child, this.realm, this.session);
                URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(child.getId()).build(new Object[0]);
                builder.status(201).location(uri);
                rep.setId(child.getId());
                this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), child.getId());
            }
        }
        catch (ModelDuplicateException mde) {
            throw ErrorResponse.exists("Top level group named '" + groupName + "' already exists.");
        }
        this.adminEvent.representation(rep).success();
        return builder.build();
    }
}

