/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.HexUtil;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static @Nullable byte[] clone(@Nullable byte[] value) {
        return value == null ? null : (byte[])value.clone();
    }

    public static @Nullable String[] clone(@Nullable String[] value) {
        return value == null ? null : (String[])value.clone();
    }

    public static @Nullable String toHexString(@Nullable byte[] value) {
        return value == null ? null : HexUtil.encodeToString(value);
    }

    public static @NonNull byte[] convertToFixedByteArray(@NonNull BigInteger value) {
        return ArrayUtil.convertToFixedByteArray(32, value);
    }

    public static @NonNull byte[] convertToFixedByteArray(int fixedSize, @NonNull BigInteger value) {
        byte[] bytes = value.toByteArray();
        byte[] adjusted = new byte[fixedSize];
        if (bytes.length <= fixedSize) {
            System.arraycopy(bytes, 0, adjusted, fixedSize - bytes.length, bytes.length);
        } else if (bytes.length == fixedSize + 1 && bytes[0] == 0) {
            System.arraycopy(bytes, 1, adjusted, 0, fixedSize);
        } else {
            throw new IllegalStateException("Value is too large, fixedSize: " + fixedSize + ", array size: " + bytes.length + ", starts with 0: " + (bytes[0] == 0 ? "yes" : "no"));
        }
        return adjusted;
    }
}

