/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.AbstractCollectionBatchLoader;
import org.hibernate.loader.ast.internal.CollectionLoaderSingleKey;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadChunker;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.CollectionBatchLoader;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class CollectionBatchLoaderInPredicate
extends AbstractCollectionBatchLoader
implements CollectionBatchLoader,
SqlArrayMultiKeyLoader {
    private final int keyColumnCount;
    private final int sqlBatchSize;
    private final JdbcParametersList jdbcParameters;
    private final SelectStatement sqlAst;
    private final JdbcOperationQuerySelect jdbcSelect;
    private CollectionLoaderSingleKey singleKeyLoader;

    public CollectionBatchLoaderInPredicate(int domainBatchSize, LoadQueryInfluencers influencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor sessionFactory) {
        super(domainBatchSize, influencers, attributeMapping, sessionFactory);
        this.keyColumnCount = attributeMapping.getKeyDescriptor().getJdbcTypeCount();
        this.sqlBatchSize = sessionFactory.getJdbcServices().getDialect().getBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.keyColumnCount, domainBatchSize, false);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_DEBUG_ENABLED) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Using IN-predicate batch fetching strategy for collection `%s` : %s (%s)", (Object)attributeMapping.getNavigableRole().getFullPath(), (Object)this.sqlBatchSize, (Object)domainBatchSize);
        }
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)attributeMapping, null, attributeMapping.getKeyDescriptor(), null, this.sqlBatchSize, influencers, LockOptions.NONE, jdbcParametersBuilder::add, sessionFactory);
        this.jdbcParameters = jdbcParametersBuilder.build();
        assert (this.jdbcParameters.size() == this.sqlBatchSize * this.keyColumnCount);
        this.jdbcSelect = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    @Override
    public PersistentCollection<?> load(Object key, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_DEBUG_ENABLED) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Loading collection `%s#%s` by batch-fetch", (Object)this.getLoadable().getNavigableRole().getFullPath(), key);
        }
        MutableInteger nonNullCounter = new MutableInteger();
        ArrayList<Object> keysToInitialize = CollectionHelper.arrayList(this.getDomainBatchSize());
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableCollectionKeys(this.getDomainBatchSize(), (index, batchableKey) -> {
            keysToInitialize.add(batchableKey);
            if (batchableKey != null) {
                nonNullCounter.increment();
            }
        }, key, this.getLoadable().asPluralAttributeMapping());
        if (nonNullCounter.get() <= 0) {
            throw new IllegalStateException("Number of non-null collection keys to batch fetch should never be 0");
        }
        if (nonNullCounter.get() == 1) {
            this.prepareSingleKeyLoaderIfNeeded();
            return this.singleKeyLoader.load(key, session);
        }
        this.initializeKeys(key, keysToInitialize.toArray(keysToInitialize.toArray(new Object[0])), nonNullCounter.get(), session);
        CollectionKey collectionKey = new CollectionKey(this.getLoadable().getCollectionDescriptor(), key);
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    private void prepareSingleKeyLoaderIfNeeded() {
        if (this.singleKeyLoader == null) {
            this.singleKeyLoader = new CollectionLoaderSingleKey(this.getLoadable(), this.getInfluencers(), this.getSessionFactory());
        }
    }

    private <T> void initializeKeys(T key, T[] keysToInitialize, int nonNullKeysToInitializeCount, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_DEBUG_ENABLED) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Collection keys to batch-fetch initialize (`%s#%s`) %s", (Object)this.getLoadable().getNavigableRole().getFullPath(), key, keysToInitialize);
        }
        MultiKeyLoadChunker<Object> chunker = new MultiKeyLoadChunker<Object>(this.sqlBatchSize, this.keyColumnCount, this.getLoadable().getKeyDescriptor(), this.jdbcParameters, this.sqlAst, this.jdbcSelect);
        BatchFetchQueue batchFetchQueue = session.getPersistenceContextInternal().getBatchFetchQueue();
        chunker.processChunks(keysToInitialize, nonNullKeysToInitializeCount, (jdbcParameterBindings, session1) -> {
            SubselectFetch.RegistrationHandler registrationHandler = SubselectFetch.createRegistrationHandler(batchFetchQueue, this.sqlAst, this.jdbcParameters, jdbcParameterBindings);
            return new ExecutionContextWithSubselectFetchHandler(session, registrationHandler);
        }, (key1, relativePosition, absolutePosition) -> {}, startIndex -> {
            if (MultiKeyLoadLogging.MULTI_KEY_LOAD_DEBUG_ENABLED) {
                MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Processing collection batch-fetch chunk (`%s#%s`) %s - %s", new Object[]{this.getLoadable().getNavigableRole().getFullPath(), key, startIndex, startIndex + (this.sqlBatchSize - 1)});
            }
        }, (startIndex, nonNullElementCount) -> {
            if (MultiKeyLoadLogging.MULTI_KEY_LOAD_DEBUG_ENABLED) {
                MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Finishing collection batch-fetch chunk (`%s#%s`) %s - %s (%s)", new Object[]{this.getLoadable().getNavigableRole().getFullPath(), key, startIndex, startIndex + (this.sqlBatchSize - 1), nonNullElementCount});
            }
            for (int i = 0; i < nonNullElementCount; ++i) {
                int keyPosition = i + startIndex;
                if (keyPosition >= keysToInitialize.length) continue;
                Object keyToInitialize = keysToInitialize[keyPosition];
                this.finishInitializingKey(keyToInitialize, session);
            }
        }, session);
    }
}

