/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.jboss.logging.Logger;

public class JpaMapUtils {
    public static final String QUERY_NATIVE_SUFFIX = "[native]";
    public static final String QUERY_JPQL_SUFFIX = "[jpql]";
    private static final Logger logger = Logger.getLogger(JpaMapUtils.class);

    public static String getSchemaForNativeQuery(EntityManager em) {
        String schema = (String)em.getEntityManagerFactory().getProperties().get("hibernate.default_schema");
        return schema == null ? "" : schema + ".";
    }

    public static Properties loadSpecificNamedQueries(String databaseType) {
        URL specificUrl = JpaMapUtils.class.getClassLoader().getResource("META-INF/jpa-map/queries-" + databaseType + ".properties");
        URL defaultUrl = JpaMapUtils.class.getClassLoader().getResource("META-INF/jpa-map/queries-default.properties");
        if (defaultUrl == null) {
            throw new IllegalStateException("META-INF/jpa-map/queries-default.properties was not found in the classpath");
        }
        Properties specificQueries = JpaMapUtils.loadSqlProperties(specificUrl);
        Properties defaultQueries = JpaMapUtils.loadSqlProperties(defaultUrl);
        Properties queries = new Properties();
        for (String queryNameFull : defaultQueries.stringPropertyNames()) {
            String querySql = defaultQueries.getProperty(queryNameFull);
            String queryName = JpaMapUtils.getQueryShortName(queryNameFull);
            String specificQueryNameFull = JpaMapUtils.getQueryFromProperties(queryName, specificQueries);
            if (specificQueryNameFull != null) {
                queryNameFull = specificQueryNameFull;
                querySql = specificQueries.getProperty(queryNameFull);
            }
            queries.put(queryNameFull, querySql);
        }
        return queries;
    }

    private static String getQueryFromProperties(String name, Properties queries) {
        if (queries == null) {
            return null;
        }
        String nameFull = name + QUERY_NATIVE_SUFFIX;
        if (queries.containsKey(nameFull)) {
            return nameFull;
        }
        nameFull = name + QUERY_JPQL_SUFFIX;
        if (queries.containsKey(nameFull)) {
            return nameFull;
        }
        nameFull = name;
        if (queries.containsKey(nameFull)) {
            return nameFull;
        }
        return null;
    }

    public static Properties loadSqlProperties(URL url) {
        if (url == null) {
            return null;
        }
        Properties props = new Properties();
        try (InputStream is = url.openStream();){
            props.load(is);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return props;
    }

    public static void configureNamedQuery(String queryName, String querySql, EntityManager entityManager) {
        boolean isNative = queryName.endsWith(QUERY_NATIVE_SUFFIX);
        queryName = JpaMapUtils.getQueryShortName(queryName);
        logger.tracef("adding query from properties files native=%b %s:%s", (Object)isNative, (Object)queryName, (Object)querySql);
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)entityManager.getEntityManagerFactory().unwrap(SessionFactoryImplementor.class);
        if (isNative) {
            sessionFactory.addNamedQuery(queryName, entityManager.createNativeQuery(querySql));
        } else {
            sessionFactory.addNamedQuery(queryName, entityManager.createQuery(querySql));
        }
    }

    private static String getQueryShortName(String name) {
        if (name.endsWith(QUERY_NATIVE_SUFFIX)) {
            return name.substring(0, name.length() - QUERY_NATIVE_SUFFIX.length());
        }
        if (name.endsWith(QUERY_JPQL_SUFFIX)) {
            return name.substring(0, name.length() - QUERY_JPQL_SUFFIX.length());
        }
        return name;
    }

    public static String getDatabaseType(String productName) {
        switch (productName) {
            case "Microsoft SQL Server": 
            case "SQLOLEDB": {
                return "mssql";
            }
            case "EnterpriseDB": {
                return "postgresql";
            }
        }
        return productName.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSpecificNamedQueries(EntityManagerFactory emf) {
        try (EntityManager em = null;){
            em = emf.createEntityManager();
            String dbProductName = (String)((Session)em.unwrap(Session.class)).doReturningWork(connection -> connection.getMetaData().getDatabaseProductName());
            String dbKind = JpaMapUtils.getDatabaseType(dbProductName);
            String schemaForNativeQuery = JpaMapUtils.getSchemaForNativeQuery(em);
            for (Map.Entry<Object, Object> query : JpaMapUtils.loadSpecificNamedQueries(dbKind.toLowerCase()).entrySet()) {
                String queryName = query.getKey().toString();
                String querySql = query.getValue().toString();
                querySql = querySql.replaceAll(Pattern.quote("${schemaprefix}"), schemaForNativeQuery);
                JpaMapUtils.configureNamedQuery(queryName, querySql, em);
            }
        }
    }
}

