/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.userSession;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import java.util.UUID;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaUserSessionEntity;
import org.keycloak.storage.SearchableModelField;

public class JpaUserSessionModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaUserSessionEntity, UserSessionModel, JpaUserSessionModelCriteriaBuilder> {
    public JpaUserSessionModelCriteriaBuilder() {
        super(JpaUserSessionModelCriteriaBuilder::new);
    }

    private JpaUserSessionModelCriteriaBuilder(JpaPredicateFunction<JpaUserSessionEntity> predicateFunc) {
        super(JpaUserSessionModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaUserSessionModelCriteriaBuilder compare(SearchableModelField<? super UserSessionModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == UserSessionModel.SearchableFields.ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserSessionModelCriteriaBuilder((cb, query, root) -> {
                        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(Objects.toString(value[0], null));
                        if (uuid == null) {
                            return cb.or(new Predicate[0]);
                        }
                        return cb.equal((Expression)root.get(modelField.getName()), (Object)uuid);
                    });
                }
                if (modelField == UserSessionModel.SearchableFields.REALM_ID || modelField == UserSessionModel.SearchableFields.USER_ID || modelField == UserSessionModel.SearchableFields.BROKER_USER_ID || modelField == UserSessionModel.SearchableFields.BROKER_SESSION_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserSessionModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == UserSessionModel.SearchableFields.IS_OFFLINE) {
                    this.validateValue(value, modelField, op, Boolean.class);
                    return new JpaUserSessionModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get("offline"), value[0]));
                }
                if (modelField == UserSessionModel.SearchableFields.CORRESPONDING_SESSION_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserSessionModelCriteriaBuilder((cb, query, root) -> {
                        Join join = root.join("notes", JoinType.LEFT);
                        return cb.and((Expression)cb.equal((Expression)join.get("name"), (Object)"correspondingSessionId"), (Expression)cb.equal((Expression)join.get("value"), value[0]));
                    });
                }
                if (modelField == UserSessionModel.SearchableFields.CLIENT_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserSessionModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.join("clientSessions", JoinType.LEFT).get("clientId"), value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

