/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.userSession.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaChildEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaClientSessionMetadata;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaClientSessionNoteEntity;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaUserSessionEntity;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;

@Entity
@Table(name="kc_client_session")
@EnhancementInfo(version="6.2.5.Final")
public class JpaClientSessionEntity
extends MapAuthenticatedClientSessionEntity.AbstractAuthenticatedClientSessionEntity
implements JpaRootVersionedEntity,
JpaChildEntity<JpaUserSessionEntity>,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    UUID id;
    @Version
    @Column
    int version;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaClientSessionMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String clientId;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    Set<JpaClientSessionNoteEntity> notes = new HashSet<JpaClientSessionNoteEntity>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_root")
    JpaUserSessionEntity root;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaClientSessionEntity() {
        this.metadata = new JpaClientSessionMetadata();
    }

    public JpaClientSessionEntity(DeepCloner cloner) {
        this.metadata = new JpaClientSessionMetadata(cloner);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public JpaUserSessionEntity getParent() {
        return this.$$_hibernate_read_root();
    }

    public void setParent(JpaUserSessionEntity root) {
        this.$$_hibernate_write_root(root);
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_CLIENT_SESSION;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getRealmId() {
        return this.$$_hibernate_read_metadata().getRealmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public String getClientId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getClientId();
        }
        return this.$$_hibernate_read_clientId();
    }

    public void setClientId(String clientId) {
        this.$$_hibernate_read_metadata().setClientId(clientId);
    }

    public String getAuthMethod() {
        return this.$$_hibernate_read_metadata().getAuthMethod();
    }

    public void setAuthMethod(String authMethod) {
        this.$$_hibernate_read_metadata().setAuthMethod(authMethod);
    }

    public String getRedirectUri() {
        return this.$$_hibernate_read_metadata().getRedirectUri();
    }

    public void setRedirectUri(String redirectUri) {
        this.$$_hibernate_read_metadata().setRedirectUri(redirectUri);
    }

    public Long getTimestamp() {
        return this.$$_hibernate_read_metadata().getTimestamp();
    }

    public void setTimestamp(Long timestamp) {
        this.$$_hibernate_read_metadata().setTimestamp(timestamp);
    }

    public Long getExpiration() {
        return this.$$_hibernate_read_metadata().getExpiration();
    }

    public void setExpiration(Long expiration) {
        this.$$_hibernate_read_metadata().setExpiration(expiration);
    }

    public String getAction() {
        return this.$$_hibernate_read_metadata().getAction();
    }

    public void setAction(String action) {
        this.$$_hibernate_read_metadata().setAction(action);
    }

    public String getCurrentRefreshToken() {
        return this.$$_hibernate_read_metadata().getCurrentRefreshToken();
    }

    public void setCurrentRefreshToken(String currentRefreshToken) {
        this.$$_hibernate_read_metadata().setCurrentRefreshToken(currentRefreshToken);
    }

    public Integer getCurrentRefreshTokenUseCount() {
        return this.$$_hibernate_read_metadata().getCurrentRefreshTokenUseCount();
    }

    public void setCurrentRefreshTokenUseCount(Integer currentRefreshTokenUseCount) {
        this.$$_hibernate_read_metadata().setCurrentRefreshTokenUseCount(currentRefreshTokenUseCount);
    }

    public Boolean isOffline() {
        return this.$$_hibernate_read_metadata().isOffline();
    }

    public void setOffline(Boolean offline) {
        this.$$_hibernate_read_metadata().setOffline(offline);
    }

    public Map<String, String> getNotes() {
        return this.$$_hibernate_read_notes().stream().collect(Collectors.toMap(JpaAttributeEntity::getName, JpaAttributeEntity::getValue));
    }

    public void setNotes(Map<String, String> notes) {
        this.$$_hibernate_read_notes().clear();
        if (notes == null) {
            return;
        }
        for (Map.Entry<String, String> entry : notes.entrySet()) {
            this.setNote(entry.getKey(), entry.getValue());
        }
    }

    public String getNote(String name) {
        return this.$$_hibernate_read_notes().stream().filter(obj -> Objects.equals(obj.getName(), name)).findFirst().map(JpaAttributeEntity::getValue).orElse(null);
    }

    public Boolean removeNote(String name) {
        return this.$$_hibernate_read_notes().removeIf(obj -> Objects.equals(obj.getName(), name));
    }

    public void setNote(String name, String value) {
        this.removeNote(name);
        if (name == null || value == null || value.trim().isEmpty()) {
            return;
        }
        this.$$_hibernate_read_notes().add(new JpaClientSessionNoteEntity(this, name, value));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaClientSessionEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaClientSessionEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaClientSessionMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaClientSessionMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public Set $$_hibernate_read_notes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "notes", this.notes);
        }
        return this.notes;
    }

    public JpaUserSessionEntity $$_hibernate_read_root() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.root = (JpaUserSessionEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "root", (Object)this.root);
        }
        return this.root;
    }

    public void $$_hibernate_write_root(JpaUserSessionEntity jpaUserSessionEntity) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.root = (JpaUserSessionEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "root", (Object)this.root, (Object)jpaUserSessionEntity);
            return;
        }
        this.root = jpaUserSessionEntity;
    }
}

