/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Nationalized;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

@Entity
@Table(name="RESOURCE_SERVER_POLICY", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID"})})
@NamedQueries(value={@NamedQuery(name="findPolicyIdByServerId", query="select p.id from PolicyEntity p where  p.resourceServer.id = :serverId "), @NamedQuery(name="findPolicyIdByName", query="select p from PolicyEntity p left join fetch p.associatedPolicies a where  p.resourceServer.id = :serverId  and p.name = :name"), @NamedQuery(name="findPolicyIdByResource", query="select p from PolicyEntity p inner join p.resources r where p.resourceServer.id = :serverId and (r.resourceServer = :serverId and r.id = :resourceId)"), @NamedQuery(name="findPolicyIdByScope", query="select pe from PolicyEntity pe inner join pe.scopes s where pe.type = 'scope' and pe.resourceServer.id = :serverId and s.id in (:scopeIds)"), @NamedQuery(name="findPolicyIdByResourceScope", query="select pe from PolicyEntity pe inner join pe.resources r inner join pe.scopes s where pe.resourceServer.id = :serverId and pe.type = 'scope' and s.id in (:scopeIds) and r.id in (:resourceId)"), @NamedQuery(name="findPolicyIdByNullResourceScope", query="select pe from PolicyEntity pe left join fetch pe.config c inner join pe.scopes s  where pe.resourceServer.id = :serverId and pe.type = 'scope' and pe.resources is empty and s.id in (:scopeIds) and not exists (select pec from pe.config pec where KEY(pec) = 'defaultResourceType')"), @NamedQuery(name="findPolicyIdByType", query="select p.id from PolicyEntity p where p.resourceServer.id = :serverId and p.type = :type"), @NamedQuery(name="findPolicyIdByResourceType", query="select p from PolicyEntity p inner join p.config c inner join fetch p.associatedPolicies a where p.resourceServer.id = :serverId and KEY(c) = 'defaultResourceType' and c like :type"), @NamedQuery(name="findPolicyIdByDependentPolices", query="select p.id from PolicyEntity p inner join p.associatedPolicies ap where p.resourceServer.id = :serverId and (ap.resourceServer.id = :serverId and ap.id = :policyId)"), @NamedQuery(name="deletePolicyByResourceServer", query="delete from PolicyEntity p where p.resourceServer.id = :serverId")})
@EnhancementInfo(version="6.2.5.Final")
public class PolicyEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    String id;
    @Column(name="NAME")
    String name;
    @Nationalized
    @Column(name="DESCRIPTION")
    String description;
    @Column(name="TYPE")
    String type;
    @Column(name="DECISION_STRATEGY")
    DecisionStrategy decisionStrategy;
    @Column(name="LOGIC")
    Logic logic;
    @ElementCollection(fetch=FetchType.LAZY)
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE", columnDefinition="TEXT")
    @CollectionTable(name="POLICY_CONFIG", joinColumns={@JoinColumn(name="POLICY_ID")})
    Map<String, String> config;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_SERVER_ID")
    ResourceServerEntity resourceServer;
    @OneToMany(fetch=FetchType.EAGER, cascade={})
    @JoinTable(name="ASSOCIATED_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="ASSOCIATED_POLICY_ID")})
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    Set<PolicyEntity> associatedPolicies;
    @OneToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="RESOURCE_ID")})
    Set<ResourceEntity> resources;
    @OneToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="SCOPE_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="SCOPE_ID")})
    Set<ScopeEntity> scopes;
    @Column(name="OWNER")
    String owner;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public PolicyEntity() {
        this.$$_hibernate_write_decisionStrategy(DecisionStrategy.UNANIMOUS);
        this.$$_hibernate_write_logic(Logic.POSITIVE);
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getType() {
        return this.$$_hibernate_read_type();
    }

    public void setType(String type) {
        this.$$_hibernate_write_type(type);
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.$$_hibernate_read_decisionStrategy();
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.$$_hibernate_write_decisionStrategy(decisionStrategy);
    }

    public Logic getLogic() {
        return this.$$_hibernate_read_logic();
    }

    public void setLogic(Logic logic) {
        this.$$_hibernate_write_logic(logic);
    }

    public Map<String, String> getConfig() {
        if (this.$$_hibernate_read_config() == null) {
            this.$$_hibernate_write_config(new HashMap());
        }
        return this.$$_hibernate_read_config();
    }

    public void setConfig(Map<String, String> config) {
        this.$$_hibernate_write_config(config);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getDescription() {
        return this.$$_hibernate_read_description();
    }

    public void setDescription(String description) {
        this.$$_hibernate_write_description(description);
    }

    public ResourceServerEntity getResourceServer() {
        return this.$$_hibernate_read_resourceServer();
    }

    public void setResourceServer(ResourceServerEntity resourceServer) {
        this.$$_hibernate_write_resourceServer(resourceServer);
    }

    public Set<ResourceEntity> getResources() {
        if (this.$$_hibernate_read_resources() == null) {
            this.$$_hibernate_write_resources(new HashSet());
        }
        return this.$$_hibernate_read_resources();
    }

    public void setResources(Set<ResourceEntity> resources) {
        this.$$_hibernate_write_resources(resources);
    }

    public Set<ScopeEntity> getScopes() {
        if (this.$$_hibernate_read_scopes() == null) {
            this.$$_hibernate_write_scopes(new HashSet());
        }
        return this.$$_hibernate_read_scopes();
    }

    public void setScopes(Set<ScopeEntity> scopes) {
        this.$$_hibernate_write_scopes(scopes);
    }

    public Set<PolicyEntity> getAssociatedPolicies() {
        if (this.$$_hibernate_read_associatedPolicies() == null) {
            this.$$_hibernate_write_associatedPolicies(new HashSet());
        }
        return this.$$_hibernate_read_associatedPolicies();
    }

    public void setAssociatedPolicies(Set<PolicyEntity> associatedPolicies) {
        this.$$_hibernate_write_associatedPolicies(associatedPolicies);
    }

    public String getOwner() {
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_write_owner(owner);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyEntity that = (PolicyEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        PolicyEntity policyEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block12: {
            int n2;
            block13: {
                int n3;
                PolicyEntity policyEntity = this;
                PolicyEntity policyEntity2 = policyEntity;
                PolicyEntity policyEntity3 = policyEntity2;
                PolicyEntity policyEntity4 = policyEntity3;
                int n4 = 0;
                if (n4 == 0 && policyEntity3.$$_hibernate_collectionTracker != null) {
                    int n5 = policyEntity3.$$_hibernate_collectionTracker.getSize("config");
                    if (policyEntity3.config == null && n5 != -1) {
                        n4 = 1;
                    } else if (policyEntity3.config != null && (!(policyEntity3.config instanceof PersistentCollection) || ((PersistentCollection)policyEntity3.config).wasInitialized()) && n5 != policyEntity3.config.size()) {
                        n4 = 1;
                    }
                }
                if ((n3 = n4) == 0 && policyEntity2.$$_hibernate_collectionTracker != null) {
                    n4 = policyEntity2.$$_hibernate_collectionTracker.getSize("associatedPolicies");
                    if (policyEntity2.associatedPolicies == null && n4 != -1) {
                        n3 = 1;
                    } else if (policyEntity2.associatedPolicies != null && (!(policyEntity2.associatedPolicies instanceof PersistentCollection) || ((PersistentCollection)policyEntity2.associatedPolicies).wasInitialized()) && n4 != policyEntity2.associatedPolicies.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && policyEntity.$$_hibernate_collectionTracker != null) {
                    n3 = policyEntity.$$_hibernate_collectionTracker.getSize("resources");
                    if (policyEntity.resources == null && n3 != -1) {
                        n2 = 1;
                    } else if (policyEntity.resources != null && (!(policyEntity.resources instanceof PersistentCollection) || ((PersistentCollection)policyEntity.resources).wasInitialized()) && n3 != policyEntity.resources.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block12;
                n2 = this.$$_hibernate_collectionTracker.getSize("scopes");
                if (this.scopes != null || n2 == -1) break block13;
                n = 1;
                break block12;
            }
            if (this.scopes == null || this.scopes instanceof PersistentCollection && !((PersistentCollection)this.scopes).wasInitialized() || n2 == this.scopes.size()) break block12;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block12: {
            int n;
            block13: {
                PolicyEntity policyEntity = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                PolicyEntity policyEntity2 = policyEntity;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                PolicyEntity policyEntity3 = policyEntity2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                PolicyEntity policyEntity4 = policyEntity3;
                DirtyTracker dirtyTracker5 = dirtyTracker4;
                if (policyEntity3.$$_hibernate_collectionTracker != null) {
                    int n2 = policyEntity3.$$_hibernate_collectionTracker.getSize("config");
                    if (policyEntity3.config == null && n2 != -1) {
                        dirtyTracker4.add("config");
                    } else if (policyEntity3.config != null && (!(policyEntity3.config instanceof PersistentCollection) || ((PersistentCollection)policyEntity3.config).wasInitialized()) && n2 != policyEntity3.config.size()) {
                        dirtyTracker4.add("config");
                    }
                }
                if (policyEntity2.$$_hibernate_collectionTracker != null) {
                    int n3 = policyEntity2.$$_hibernate_collectionTracker.getSize("associatedPolicies");
                    if (policyEntity2.associatedPolicies == null && n3 != -1) {
                        dirtyTracker3.add("associatedPolicies");
                    } else if (policyEntity2.associatedPolicies != null && (!(policyEntity2.associatedPolicies instanceof PersistentCollection) || ((PersistentCollection)policyEntity2.associatedPolicies).wasInitialized()) && n3 != policyEntity2.associatedPolicies.size()) {
                        dirtyTracker3.add("associatedPolicies");
                    }
                }
                if (policyEntity.$$_hibernate_collectionTracker != null) {
                    int n4 = policyEntity.$$_hibernate_collectionTracker.getSize("resources");
                    if (policyEntity.resources == null && n4 != -1) {
                        dirtyTracker2.add("resources");
                    } else if (policyEntity.resources != null && (!(policyEntity.resources instanceof PersistentCollection) || ((PersistentCollection)policyEntity.resources).wasInitialized()) && n4 != policyEntity.resources.size()) {
                        dirtyTracker2.add("resources");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block12;
                n = this.$$_hibernate_collectionTracker.getSize("scopes");
                if (this.scopes != null || n == -1) break block13;
                dirtyTracker.add("scopes");
                break block12;
            }
            if (this.scopes == null || this.scopes instanceof PersistentCollection && !((PersistentCollection)this.scopes).wasInitialized() || n == this.scopes.size()) break block12;
            dirtyTracker.add("scopes");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block12: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            PolicyEntity policyEntity = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            PolicyEntity policyEntity2 = policyEntity;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            PolicyEntity policyEntity3 = policyEntity2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            PolicyEntity policyEntity4 = policyEntity3;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor5 = lazyAttributeLoadingInterceptor4;
            if (lazyAttributeLoadingInterceptor4 == null || lazyAttributeLoadingInterceptor4.isAttributeLoaded("config")) {
                if (policyEntity3.config == null || policyEntity3.config instanceof PersistentCollection && !((PersistentCollection)policyEntity3.config).wasInitialized()) {
                    policyEntity3.$$_hibernate_collectionTracker.add("config", -1);
                } else {
                    policyEntity3.$$_hibernate_collectionTracker.add("config", policyEntity3.config.size());
                }
            }
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("associatedPolicies")) {
                if (policyEntity2.associatedPolicies == null || policyEntity2.associatedPolicies instanceof PersistentCollection && !((PersistentCollection)policyEntity2.associatedPolicies).wasInitialized()) {
                    policyEntity2.$$_hibernate_collectionTracker.add("associatedPolicies", -1);
                } else {
                    policyEntity2.$$_hibernate_collectionTracker.add("associatedPolicies", policyEntity2.associatedPolicies.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("resources")) {
                if (policyEntity.resources == null || policyEntity.resources instanceof PersistentCollection && !((PersistentCollection)policyEntity.resources).wasInitialized()) {
                    policyEntity.$$_hibernate_collectionTracker.add("resources", -1);
                } else {
                    policyEntity.$$_hibernate_collectionTracker.add("resources", policyEntity.resources.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("scopes")) break block12;
            if (this.scopes == null || this.scopes instanceof PersistentCollection && !((PersistentCollection)this.scopes).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("scopes", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("scopes", this.scopes.size());
            }
        }
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"description", (Object)string, (Object)this.description)) {
            this.$$_hibernate_trackChange("description");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public String $$_hibernate_read_type() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "type", (Object)this.type);
        }
        return this.type;
    }

    public void $$_hibernate_write_type(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"type", (Object)string, (Object)this.type)) {
            this.$$_hibernate_trackChange("type");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "type", (Object)this.type, (Object)string);
            return;
        }
        this.type = string;
    }

    public DecisionStrategy $$_hibernate_read_decisionStrategy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.decisionStrategy = (DecisionStrategy)this.$$_hibernate_getInterceptor().readObject((Object)this, "decisionStrategy", (Object)this.decisionStrategy);
        }
        return this.decisionStrategy;
    }

    public void $$_hibernate_write_decisionStrategy(DecisionStrategy decisionStrategy) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"decisionStrategy", (Object)decisionStrategy, (Object)this.decisionStrategy)) {
            this.$$_hibernate_trackChange("decisionStrategy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.decisionStrategy = (DecisionStrategy)this.$$_hibernate_getInterceptor().writeObject((Object)this, "decisionStrategy", (Object)this.decisionStrategy, (Object)decisionStrategy);
            return;
        }
        this.decisionStrategy = decisionStrategy;
    }

    public Logic $$_hibernate_read_logic() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.logic = (Logic)this.$$_hibernate_getInterceptor().readObject((Object)this, "logic", (Object)this.logic);
        }
        return this.logic;
    }

    public void $$_hibernate_write_logic(Logic logic) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"logic", (Object)logic, (Object)this.logic)) {
            this.$$_hibernate_trackChange("logic");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.logic = (Logic)this.$$_hibernate_getInterceptor().writeObject((Object)this, "logic", (Object)this.logic, (Object)logic);
            return;
        }
        this.logic = logic;
    }

    public Map $$_hibernate_read_config() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.config = (Map)this.$$_hibernate_getInterceptor().readObject((Object)this, "config", this.config);
        }
        return this.config;
    }

    public void $$_hibernate_write_config(Map map) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"config", (Object)map, this.config)) {
            this.$$_hibernate_trackChange("config");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.config = (Map)this.$$_hibernate_getInterceptor().writeObject((Object)this, "config", this.config, (Object)map);
            return;
        }
        this.config = map;
    }

    public ResourceServerEntity $$_hibernate_read_resourceServer() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (ResourceServerEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceServer", (Object)this.resourceServer);
        }
        return this.resourceServer;
    }

    public void $$_hibernate_write_resourceServer(ResourceServerEntity resourceServerEntity) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"resourceServer", (Object)resourceServerEntity, (Object)this.resourceServer)) {
            this.$$_hibernate_trackChange("resourceServer");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (ResourceServerEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceServer", (Object)this.resourceServer, (Object)resourceServerEntity);
            return;
        }
        this.resourceServer = resourceServerEntity;
    }

    public Set $$_hibernate_read_associatedPolicies() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.associatedPolicies = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "associatedPolicies", this.associatedPolicies);
        }
        return this.associatedPolicies;
    }

    public void $$_hibernate_write_associatedPolicies(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.associatedPolicies = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "associatedPolicies", this.associatedPolicies, (Object)set);
            return;
        }
        this.associatedPolicies = set;
    }

    public Set $$_hibernate_read_resources() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resources = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "resources", this.resources);
        }
        return this.resources;
    }

    public void $$_hibernate_write_resources(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resources = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resources", this.resources, (Object)set);
            return;
        }
        this.resources = set;
    }

    public Set $$_hibernate_read_scopes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "scopes", this.scopes);
        }
        return this.scopes;
    }

    public void $$_hibernate_write_scopes(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopes = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "scopes", this.scopes, (Object)set);
            return;
        }
        this.scopes = set;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"owner", (Object)string, (Object)this.owner)) {
            this.$$_hibernate_trackChange("owner");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }
}

