/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.StringUtil;

public class AuthenticatorUtil {
    private static final Logger logger = Logger.getLogger(AuthenticatorUtil.class);
    public static String CALLBACKS_FACTORY_IDS_NOTE = "callbacksFactoryProviderIds";

    public static boolean isSSOAuthentication(AuthenticationSessionModel authSession) {
        return "true".equals(authSession.getAuthNote("SSO_AUTH"));
    }

    public static boolean isForcedReauthentication(AuthenticationSessionModel authSession) {
        return "true".equals(authSession.getAuthNote("FORCED_REAUTHENTICATION"));
    }

    public static void setAuthCallbacksFactoryIds(AuthenticationSessionModel authSession, String authFactoryId) {
        if (authSession == null || StringUtil.isBlank((String)authFactoryId)) {
            return;
        }
        String callbacksFactories = authSession.getAuthNote(CALLBACKS_FACTORY_IDS_NOTE);
        if (StringUtil.isNotBlank((String)callbacksFactories)) {
            boolean containsProviderId;
            boolean bl = containsProviderId = callbacksFactories.equals(authFactoryId) || callbacksFactories.contains("##" + authFactoryId) || callbacksFactories.contains(authFactoryId + "##");
            if (!containsProviderId) {
                authSession.setAuthNote(CALLBACKS_FACTORY_IDS_NOTE, callbacksFactories + "##" + authFactoryId);
            }
        } else {
            authSession.setAuthNote(CALLBACKS_FACTORY_IDS_NOTE, authFactoryId);
        }
    }

    public static Set<String> getAuthCallbacksFactoryIds(AuthenticationSessionModel authSession) {
        if (authSession == null) {
            return Collections.emptySet();
        }
        String callbacksFactories = authSession.getAuthNote(CALLBACKS_FACTORY_IDS_NOTE);
        if (StringUtil.isNotBlank((String)callbacksFactories)) {
            return Sets.newHashSet((Object[])callbacksFactories.split("##"));
        }
        return Collections.emptySet();
    }

    public static List<AuthenticationExecutionModel> getExecutionsByType(RealmModel realm, String flowId, String providerId) {
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        realm.getAuthenticationExecutionsStream(flowId).forEach(authExecution -> {
            if (providerId.equals(authExecution.getAuthenticator())) {
                executions.add((AuthenticationExecutionModel)authExecution);
            } else if (authExecution.isAuthenticatorFlow() && authExecution.getFlowId() != null) {
                executions.addAll(AuthenticatorUtil.getExecutionsByType(realm, authExecution.getFlowId(), providerId));
            }
        });
        return executions;
    }
}

