/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.admin.representation.PolicyEvaluationResponseBuilder;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.Permissions;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionPermissionCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PolicyEvaluationRequest;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.sessions.AuthenticationSessionModel;

public class PolicyEvaluationService {
    private static final Logger logger = Logger.getLogger(PolicyEvaluationService.class);
    private final AuthorizationProvider authorization;
    private final AdminPermissionEvaluator auth;
    private final ResourceServer resourceServer;

    PolicyEvaluationService(ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response evaluate(PolicyEvaluationRequest evaluationRequest) {
        this.auth.realm().requireViewAuthorization();
        try (CloseableKeycloakIdentity identity = this.createIdentity(evaluationRequest);){
            AuthorizationRequest request = new AuthorizationRequest();
            HashMap claims = new HashMap();
            Map givenAttributes = (Map)evaluationRequest.getContext().get("attributes");
            if (givenAttributes != null) {
                givenAttributes.forEach((key, entryValue) -> {
                    if (entryValue != null) {
                        ArrayList values = new ArrayList();
                        Collections.addAll(values, entryValue.split(","));
                        claims.put(key, values);
                    }
                });
            }
            request.setClaims(claims);
            Response response = Response.ok((Object)PolicyEvaluationResponseBuilder.build(this.evaluate(evaluationRequest, this.createEvaluationContext(evaluationRequest, identity), request), this.resourceServer, this.authorization, identity)).build();
            return response;
        }
    }

    private EvaluationDecisionCollector evaluate(PolicyEvaluationRequest evaluationRequest, EvaluationContext evaluationContext, AuthorizationRequest request) {
        List<ResourcePermission> permissions = this.createPermissions(evaluationRequest, evaluationContext, this.authorization, request);
        if (permissions.isEmpty()) {
            return (EvaluationDecisionCollector)this.authorization.evaluators().from(evaluationContext, this.resourceServer, request).evaluate((Decision)new EvaluationDecisionCollector(this.authorization, this.resourceServer, request));
        }
        return (EvaluationDecisionCollector)this.authorization.evaluators().from(permissions, evaluationContext).evaluate((Decision)new EvaluationDecisionCollector(this.authorization, this.resourceServer, request));
    }

    private EvaluationContext createEvaluationContext(final PolicyEvaluationRequest representation, KeycloakIdentity identity) {
        return new DefaultEvaluationContext(identity, this.authorization.getKeycloakSession()){

            @Override
            public Attributes getAttributes() {
                HashMap attributes = new HashMap(super.getAttributes().toMap());
                Map givenAttributes = (Map)representation.getContext().get("attributes");
                if (givenAttributes != null) {
                    givenAttributes.forEach((key, entryValue) -> {
                        if (entryValue != null) {
                            ArrayList values = new ArrayList();
                            Collections.addAll(values, entryValue.split(","));
                            attributes.put(key, values);
                        }
                    });
                }
                return Attributes.from(attributes);
            }
        };
    }

    private List<ResourcePermission> createPermissions(PolicyEvaluationRequest representation, EvaluationContext evaluationContext, AuthorizationProvider authorization, AuthorizationRequest request) {
        return representation.getResources().stream().flatMap(resource -> {
            HashSet givenScopes;
            StoreFactory storeFactory = authorization.getStoreFactory();
            if (resource == null) {
                resource = new ResourceRepresentation();
            }
            if ((givenScopes = resource.getScopes()) == null) {
                givenScopes = new HashSet();
            }
            ScopeStore scopeStore = storeFactory.getScopeStore();
            Set scopes = givenScopes.stream().map(scopeRepresentation -> scopeStore.findByName(this.resourceServer, scopeRepresentation.getName())).collect(Collectors.toSet());
            if (resource.getId() != null) {
                Resource resourceModel = storeFactory.getResourceStore().findById(this.resourceServer.getRealm(), this.resourceServer, resource.getId());
                return new ArrayList<ResourcePermission>(Arrays.asList(Permissions.createResourcePermissions((Resource)resourceModel, (ResourceServer)this.resourceServer, scopes, (AuthorizationProvider)authorization, (AuthorizationRequest)request))).stream();
            }
            if (resource.getType() != null) {
                return storeFactory.getResourceStore().findByType(this.resourceServer, resource.getType()).stream().map(resource1 -> Permissions.createResourcePermissions((Resource)resource1, (ResourceServer)this.resourceServer, (Collection)scopes, (AuthorizationProvider)authorization, (AuthorizationRequest)request));
            }
            if (scopes.isEmpty()) {
                return Stream.empty();
            }
            List resources = storeFactory.getResourceStore().findByScopes(this.resourceServer, scopes);
            if (resources.isEmpty()) {
                return scopes.stream().map(scope -> new ResourcePermission(null, new ArrayList<Scope>(Arrays.asList(scope)), this.resourceServer));
            }
            return resources.stream().map(resource12 -> Permissions.createResourcePermissions((Resource)resource12, (ResourceServer)this.resourceServer, (Collection)scopes, (AuthorizationProvider)authorization, (AuthorizationRequest)request));
        }).collect(Collectors.toList());
    }

    private CloseableKeycloakIdentity createIdentity(PolicyEvaluationRequest representation) {
        String clientId;
        KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
        RealmModel realm = keycloakSession.getContext().getRealm();
        AccessToken accessToken = null;
        String subject = representation.getUserId();
        UserSessionModel userSession = null;
        if (subject != null) {
            UserModel userModel = keycloakSession.users().getUserById(realm, subject);
            if (userModel == null) {
                userModel = keycloakSession.users().getUserByUsername(realm, subject);
            }
            if (userModel != null) {
                clientId = representation.getClientId();
                if (clientId == null) {
                    clientId = this.resourceServer.getClientId();
                }
                if (clientId != null) {
                    ClientModel clientModel = realm.getClientById(clientId);
                    AuthenticationSessionModel authSession = keycloakSession.authenticationSessions().createRootAuthenticationSession(realm).createAuthenticationSession(clientModel);
                    authSession.setProtocol("openid-connect");
                    authSession.setAuthenticatedUser(userModel);
                    userSession = new UserSessionManager(keycloakSession).createUserSession(authSession.getParentSession().getId(), realm, userModel, userModel.getUsername(), "127.0.0.1", "passwd", false, null, null, UserSessionModel.SessionPersistenceState.PERSISTENT);
                    AuthenticationManager.setClientScopesInSession(authSession);
                    ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(keycloakSession, userSession, authSession);
                    accessToken = new TokenManager().createClientAccessToken(keycloakSession, realm, clientModel, userModel, userSession, clientSessionCtx);
                }
            }
        }
        if (accessToken == null) {
            accessToken = new AccessToken();
            accessToken.subject(representation.getUserId());
            ClientModel client = null;
            clientId = representation.getClientId();
            if (clientId != null) {
                client = realm.getClientById(clientId);
            }
            if (client == null) {
                client = realm.getClientById(this.resourceServer.getClientId());
            }
            accessToken.issuedFor(client.getClientId());
            accessToken.audience(new String[]{client.getId()});
            accessToken.issuer(Urls.realmIssuer(keycloakSession.getContext().getUri().getBaseUri(), realm.getName()));
            accessToken.setRealmAccess(new AccessToken.Access());
        }
        if (representation.getRoleIds() != null && !representation.getRoleIds().isEmpty()) {
            if (accessToken.getRealmAccess() == null) {
                accessToken.setRealmAccess(new AccessToken.Access());
            }
            AccessToken.Access realmAccess = accessToken.getRealmAccess();
            representation.getRoleIds().forEach(arg_0 -> ((AccessToken.Access)realmAccess).addRole(arg_0));
        }
        return new CloseableKeycloakIdentity(accessToken, keycloakSession, userSession);
    }

    private static class CloseableKeycloakIdentity
    extends KeycloakIdentity {
        private UserSessionModel userSession;

        public CloseableKeycloakIdentity(AccessToken accessToken, KeycloakSession keycloakSession, UserSessionModel userSession) {
            super(accessToken, keycloakSession);
            this.userSession = userSession;
        }

        public void close() {
            if (this.userSession != null) {
                this.keycloakSession.sessions().removeUserSession(this.realm, this.userSession);
            }
        }

        @Override
        public String getId() {
            UserModel serviceAccount;
            if (this.userSession != null) {
                return super.getId();
            }
            String issuedFor = this.accessToken.getIssuedFor();
            if (issuedFor != null && (serviceAccount = this.keycloakSession.users().getServiceAccount(this.realm.getClientByClientId(issuedFor))) != null) {
                return serviceAccount.getId();
            }
            return null;
        }
    }

    public static class EvaluationDecisionCollector
    extends DecisionPermissionCollector {
        public EvaluationDecisionCollector(AuthorizationProvider authorizationProvider, ResourceServer resourceServer, AuthorizationRequest request) {
            super(authorizationProvider, resourceServer, request);
        }

        protected boolean isGranted(Result.PolicyResult policyResult) {
            if (super.isGranted(policyResult)) {
                policyResult.setEffect(Decision.Effect.PERMIT);
                return true;
            }
            return false;
        }

        protected void grantPermission(AuthorizationProvider authorizationProvider, Set<Permission> permissions, ResourcePermission permission, Collection<Scope> grantedScopes, ResourceServer resourceServer, AuthorizationRequest request, Result result) {
            result.setStatus(Decision.Effect.PERMIT);
            result.getPermission().getScopes().retainAll(grantedScopes);
            super.grantPermission(authorizationProvider, permissions, permission, grantedScopes, resourceServer, request, result);
        }

        public Collection<Result> getResults() {
            return this.results.values();
        }
    }
}

