/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.io.InputStream;
import java.util.Map;
import org.keycloak.broker.oidc.KeycloakOIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.oidc.OIDCIdentityProviderFactory;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;

public class KeycloakOIDCIdentityProviderFactory
extends AbstractIdentityProviderFactory<KeycloakOIDCIdentityProvider> {
    public static final String PROVIDER_ID = "keycloak-oidc";

    public String getName() {
        return "Keycloak OpenID Connect";
    }

    public KeycloakOIDCIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new KeycloakOIDCIdentityProvider(session, new OIDCIdentityProviderConfig(model));
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Map<String, String> parseConfig(KeycloakSession session, InputStream inputStream) {
        return OIDCIdentityProviderFactory.parseOIDCConfig(session, inputStream);
    }

    public OIDCIdentityProviderConfig createConfig() {
        return new OIDCIdentityProviderConfig();
    }
}

