/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.ECDSASignatureProvider;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerAsymmetricSignatureSignerContext;
import org.keycloak.crypto.SignatureException;
import org.keycloak.models.KeycloakSession;

public class ServerECDSASignatureSignerContext
extends AsymmetricSignatureSignerContext {
    public ServerECDSASignatureSignerContext(KeycloakSession session, String algorithm) throws SignatureException {
        super(ServerAsymmetricSignatureSignerContext.getKey(session, algorithm));
    }

    public ServerECDSASignatureSignerContext(KeyWrapper key) {
        super(key);
    }

    public byte[] sign(byte[] data) throws SignatureException {
        try {
            int size = ECDSASignatureProvider.ECDSA.valueOf(this.getAlgorithm()).getSignatureLength();
            return ECDSASignatureProvider.asn1derToConcatenatedRS(super.sign(data), size);
        }
        catch (Exception e) {
            throw new SignatureException("Signing failed", (Throwable)e);
        }
    }
}

