/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.lock;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.locking.GlobalLockProvider;
import org.keycloak.models.locking.LockAcquiringTimeoutException;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.lock.MapLockEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.SearchableModelField;

public class MapGlobalLockProvider
implements GlobalLockProvider {
    private final KeycloakSession session;
    private final long defaultTimeoutMilliseconds;
    private MapStorage<MapLockEntity, MapLockEntity> store;
    private final Supplier<MapStorage<MapLockEntity, MapLockEntity>> lockStoreSupplier;

    public MapGlobalLockProvider(KeycloakSession session, long defaultTimeoutMilliseconds, Supplier<MapStorage<MapLockEntity, MapLockEntity>> lockStoreSupplier) {
        this.defaultTimeoutMilliseconds = defaultTimeoutMilliseconds;
        this.session = session;
        this.lockStoreSupplier = lockStoreSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V withLock(String lockName, Duration timeToWaitForLock, KeycloakSessionTaskWithResult<V> task) throws LockAcquiringTimeoutException {
        MapLockEntity[] lockEntity = new MapLockEntity[]{null};
        try {
            if (timeToWaitForLock == null) {
                timeToWaitForLock = Duration.ofMillis(this.defaultTimeoutMilliseconds);
            }
            String[] keycloakInstanceIdentifier = new String[]{null};
            Instant[] timeWhenAcquired = new Instant[]{null};
            try {
                Retry.executeWithBackoff(i -> {
                    lockEntity[0] = (MapLockEntity)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), innerSession -> {
                        MapGlobalLockProvider provider = (MapGlobalLockProvider)innerSession.getProvider(GlobalLockProvider.class);
                        return provider.lock(lockName);
                    });
                }, (iteration, t) -> {
                    if (t instanceof LockAcquiringTimeoutException) {
                        LockAcquiringTimeoutException ex = (LockAcquiringTimeoutException)t;
                        keycloakInstanceIdentifier[0] = ex.getKeycloakInstanceIdentifier();
                        timeWhenAcquired[0] = ex.getTimeWhenAcquired();
                    }
                }, (Duration)timeToWaitForLock, (int)500);
            }
            catch (RuntimeException ex) {
                if (!(ex instanceof LockAcquiringTimeoutException)) {
                    throw new LockAcquiringTimeoutException(lockName, keycloakInstanceIdentifier[0], timeWhenAcquired[0], (Throwable)ex);
                }
                throw ex;
            }
            Object object = KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), task);
            return (V)object;
        }
        finally {
            if (lockEntity[0] != null) {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), innerSession -> {
                    MapGlobalLockProvider provider = (MapGlobalLockProvider)innerSession.getProvider(GlobalLockProvider.class);
                    provider.unlock(lockEntity[0]);
                });
            }
        }
    }

    public void forceReleaseAllLocks() {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), innerSession -> {
            MapGlobalLockProvider provider = (MapGlobalLockProvider)innerSession.getProvider(GlobalLockProvider.class);
            provider.releaseAllLocks();
        });
    }

    public void close() {
    }

    private void prepareTx() {
        if (this.store == null) {
            this.store = this.lockStoreSupplier.get();
        }
    }

    private MapLockEntity lock(String lockName) {
        this.prepareTx();
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare((SearchableModelField)MapLockEntity.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{lockName});
        Optional<MapLockEntity> entry = this.store.read(QueryParameters.withCriteria(mcb)).findFirst();
        if (entry.isEmpty()) {
            MapLockEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapLockEntity.class);
            entity.setName(lockName);
            entity.setKeycloakInstanceIdentifier(MapGlobalLockProvider.getKeycloakInstanceIdentifier());
            entity.setTimeAcquired(Time.currentTimeMillis());
            return this.store.create(entity);
        }
        throw new LockAcquiringTimeoutException(lockName, entry.get().getKeycloakInstanceIdentifier(), Instant.ofEpochMilli(entry.get().getTimeAcquired()));
    }

    private void unlock(MapLockEntity lockEntity) {
        this.prepareTx();
        MapLockEntity readLockEntity = this.store.read(lockEntity.getId());
        if (readLockEntity == null) {
            throw new RuntimeException("didn't find lock - someone else unlocked it?");
        }
        if (!lockEntity.isLockUnchanged(readLockEntity)) {
            throw new RuntimeException(String.format("Lock owned by different instance: Lock [%s] acquired by keycloak instance [%s] at the time [%s]", readLockEntity.getName(), readLockEntity.getKeycloakInstanceIdentifier(), readLockEntity.getTimeAcquired()));
        }
        this.store.delete(readLockEntity.getId());
    }

    private void releaseAllLocks() {
        this.prepareTx();
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        this.store.delete(QueryParameters.withCriteria(mcb));
    }

    private static String getKeycloakInstanceIdentifier() {
        String hostname;
        long pid = ProcessHandle.current().pid();
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown-host";
        }
        String threadName = Thread.currentThread().getName();
        return threadName + "#" + pid + "@" + hostname;
    }
}

