/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ManagedCacheManagerProvider;
import org.keycloak.cluster.infinispan.KeycloakHotRodMarshallerFactory;
import org.keycloak.common.Profile;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProviderFactory;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.RemoteCacheProvider;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.infinispan.ClearCacheEvent;
import org.keycloak.models.cache.infinispan.events.RealmRemovedEvent;
import org.keycloak.models.cache.infinispan.events.RealmUpdatedEvent;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.InvalidationHandler;

public class DefaultInfinispanConnectionProviderFactory
implements InfinispanConnectionProviderFactory,
EnvironmentDependentProviderFactory {
    protected static final Logger logger = Logger.getLogger(DefaultInfinispanConnectionProviderFactory.class);
    protected Config.Scope config;
    protected EmbeddedCacheManager cacheManager;
    protected RemoteCacheProvider remoteCacheProvider;
    protected boolean containerManaged;
    private TopologyInfo topologyInfo;

    public InfinispanConnectionProvider create(KeycloakSession session) {
        this.lazyInit();
        return new DefaultInfinispanConnectionProvider(this.cacheManager, this.remoteCacheProvider, this.topologyInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<DefaultInfinispanConnectionProviderFactory> clazz = DefaultInfinispanConnectionProviderFactory.class;
        synchronized (DefaultInfinispanConnectionProviderFactory.class) {
            if (this.cacheManager != null && !this.containerManaged) {
                this.cacheManager.stop();
            }
            if (this.remoteCacheProvider != null) {
                this.remoteCacheProvider.stop();
            }
            this.cacheManager = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof PostMigrationEvent) {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, session -> this.registerSystemWideListeners(session));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInit() {
        if (this.cacheManager == null) {
            DefaultInfinispanConnectionProviderFactory defaultInfinispanConnectionProviderFactory = this;
            synchronized (defaultInfinispanConnectionProviderFactory) {
                if (this.cacheManager == null) {
                    EmbeddedCacheManager managedCacheManager = null;
                    Iterator<ManagedCacheManagerProvider> providers = ServiceLoader.load(ManagedCacheManagerProvider.class, DefaultInfinispanConnectionProvider.class.getClassLoader()).iterator();
                    if (providers.hasNext()) {
                        ManagedCacheManagerProvider provider = providers.next();
                        if (providers.hasNext()) {
                            throw new RuntimeException("Multiple " + ManagedCacheManagerProvider.class + " providers found.");
                        }
                        managedCacheManager = (EmbeddedCacheManager)provider.getCacheManager(this.config);
                    }
                    if (managedCacheManager == null) {
                        if (!this.config.getBoolean("embedded", Boolean.valueOf(false)).booleanValue()) {
                            throw new RuntimeException("No " + ManagedCacheManagerProvider.class.getName() + " found. If running in embedded mode set the [embedded] property to this provider.");
                        }
                        this.initEmbedded();
                    } else {
                        this.initContainerManaged(managedCacheManager);
                    }
                    logger.infof(this.topologyInfo.toString(), new Object[0]);
                    this.remoteCacheProvider = new RemoteCacheProvider(this.config, this.cacheManager);
                }
            }
        }
    }

    protected void initContainerManaged(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.containerManaged = true;
        long realmRevisionsMaxEntries = this.cacheManager.getCache("realms").getCacheConfiguration().memory().size();
        realmRevisionsMaxEntries = realmRevisionsMaxEntries > 0L ? 2L * realmRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("realmRevisions", this.getRevisionCacheConfig(realmRevisionsMaxEntries));
        this.cacheManager.getCache("realmRevisions", true);
        long userRevisionsMaxEntries = this.cacheManager.getCache("users").getCacheConfiguration().memory().size();
        userRevisionsMaxEntries = userRevisionsMaxEntries > 0L ? 2L * userRevisionsMaxEntries : 100000L;
        this.cacheManager.defineConfiguration("userRevisions", this.getRevisionCacheConfig(userRevisionsMaxEntries));
        this.cacheManager.getCache("userRevisions", true);
        this.cacheManager.getCache("authorization", true);
        this.cacheManager.getCache("authenticationSessions", true);
        this.cacheManager.getCache("keys", true);
        this.cacheManager.getCache("actionTokens", true);
        long authzRevisionsMaxEntries = this.cacheManager.getCache("authorization").getCacheConfiguration().memory().size();
        authzRevisionsMaxEntries = authzRevisionsMaxEntries > 0L ? 2L * authzRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("authorizationRevisions", this.getRevisionCacheConfig(authzRevisionsMaxEntries));
        this.cacheManager.getCache("authorizationRevisions", true);
        this.topologyInfo = new TopologyInfo(this.cacheManager, this.config, false);
        logger.debugv("Using container managed Infinispan cache container, lookup={0}", (Object)cacheManager);
    }

    protected void initEmbedded() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        boolean clustered = this.config.getBoolean("clustered", Boolean.valueOf(false));
        boolean async = this.config.getBoolean("async", Boolean.valueOf(false));
        boolean useKeycloakTimeService = this.config.getBoolean("useKeycloakTimeService", Boolean.valueOf(false));
        this.topologyInfo = new TopologyInfo(this.cacheManager, this.config, true);
        if (clustered) {
            String jgroupsUdpMcastAddr = this.config.get("jgroupsUdpMcastAddr", System.getProperty("jgroups.udp.mcast_addr"));
            InfinispanUtil.configureTransport(gcb, this.topologyInfo.getMyNodeName(), this.topologyInfo.getMySiteName(), jgroupsUdpMcastAddr, "default-configs/default-keycloak-jgroups-udp.xml");
            gcb.jmx().domain("jboss.datagrid-infinispan-" + this.topologyInfo.getMyNodeName()).enable();
        } else {
            gcb.jmx().domain("jboss.datagrid-infinispan").enable();
        }
        gcb.serialization().marshaller((Marshaller)new JBossUserMarshaller());
        this.cacheManager = new DefaultCacheManager(gcb.build());
        if (useKeycloakTimeService) {
            InfinispanUtil.setTimeServiceToKeycloakTime(this.cacheManager);
        }
        this.containerManaged = false;
        logger.debug((Object)"Started embedded Infinispan cache container");
        ConfigurationBuilder modelCacheConfigBuilder = InfinispanUtil.createCacheConfigurationBuilder();
        Configuration modelCacheConfiguration = modelCacheConfigBuilder.build();
        this.cacheManager.defineConfiguration("realms", modelCacheConfiguration);
        this.cacheManager.defineConfiguration("authorization", modelCacheConfiguration);
        this.cacheManager.defineConfiguration("users", modelCacheConfiguration);
        ConfigurationBuilder sessionConfigBuilder = InfinispanUtil.createCacheConfigurationBuilder();
        if (clustered) {
            sessionConfigBuilder.simpleCache(false);
            String sessionsMode = this.config.get("sessionsMode", "distributed");
            if (sessionsMode.equalsIgnoreCase("replicated")) {
                sessionConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
            } else if (sessionsMode.equalsIgnoreCase("distributed")) {
                sessionConfigBuilder.clustering().cacheMode(async ? CacheMode.DIST_ASYNC : CacheMode.DIST_SYNC);
            } else {
                throw new RuntimeException("Invalid value for sessionsMode");
            }
            int owners = this.config.getInt("sessionsOwners", Integer.valueOf(2));
            logger.debugf("Session owners: %d", owners);
            int l1Lifespan = this.config.getInt("l1Lifespan", Integer.valueOf(600000));
            boolean l1Enabled = l1Lifespan > 0;
            Boolean awaitInitialTransfer = this.config.getBoolean("awaitInitialTransfer", Boolean.valueOf(true));
            sessionConfigBuilder.clustering().hash().numOwners(owners).numSegments(this.config.getInt("sessionsSegments", Integer.valueOf(60)).intValue()).l1().enabled(l1Enabled).lifespan((long)l1Lifespan).stateTransfer().awaitInitialTransfer(awaitInitialTransfer.booleanValue()).timeout(30L, TimeUnit.SECONDS).build();
        }
        Configuration sessionCacheConfigurationBase = sessionConfigBuilder.build();
        boolean jdgEnabled = this.config.getBoolean("remoteStoreEnabled", Boolean.valueOf(false));
        if (jdgEnabled) {
            sessionConfigBuilder = InfinispanUtil.createCacheConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "sessions");
        }
        Configuration sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("sessions", sessionCacheConfiguration);
        if (jdgEnabled) {
            sessionConfigBuilder = InfinispanUtil.createCacheConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "offlineSessions");
        }
        sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("offlineSessions", sessionCacheConfiguration);
        if (jdgEnabled) {
            sessionConfigBuilder = InfinispanUtil.createCacheConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "clientSessions");
        }
        sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("clientSessions", sessionCacheConfiguration);
        if (jdgEnabled) {
            sessionConfigBuilder = InfinispanUtil.createCacheConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "offlineClientSessions");
        }
        sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("offlineClientSessions", sessionCacheConfiguration);
        if (jdgEnabled) {
            sessionConfigBuilder = InfinispanUtil.createCacheConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "loginFailures");
        }
        sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("loginFailures", sessionCacheConfiguration);
        this.cacheManager.defineConfiguration("authenticationSessions", sessionCacheConfigurationBase);
        this.cacheManager.getCache("sessions", true);
        this.cacheManager.getCache("offlineSessions", true);
        this.cacheManager.getCache("clientSessions", true);
        this.cacheManager.getCache("offlineClientSessions", true);
        this.cacheManager.getCache("loginFailures", true);
        this.cacheManager.getCache("authenticationSessions", true);
        ConfigurationBuilder replicationConfigBuilder = InfinispanUtil.createCacheConfigurationBuilder();
        if (clustered) {
            replicationConfigBuilder.simpleCache(false);
            replicationConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
        }
        if (jdgEnabled) {
            this.configureRemoteCacheStore(replicationConfigBuilder, async, "work");
        }
        Configuration replicationEvictionCacheConfiguration = replicationConfigBuilder.expiration().enableReaper().wakeUpInterval(15L, TimeUnit.SECONDS).build();
        this.cacheManager.defineConfiguration("work", replicationEvictionCacheConfiguration);
        this.cacheManager.getCache("work", true);
        long realmRevisionsMaxEntries = this.cacheManager.getCache("realms").getCacheConfiguration().memory().size();
        realmRevisionsMaxEntries = realmRevisionsMaxEntries > 0L ? 2L * realmRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("realmRevisions", this.getRevisionCacheConfig(realmRevisionsMaxEntries));
        this.cacheManager.getCache("realmRevisions", true);
        long userRevisionsMaxEntries = this.cacheManager.getCache("users").getCacheConfiguration().memory().size();
        userRevisionsMaxEntries = userRevisionsMaxEntries > 0L ? 2L * userRevisionsMaxEntries : 100000L;
        this.cacheManager.defineConfiguration("userRevisions", this.getRevisionCacheConfig(userRevisionsMaxEntries));
        this.cacheManager.getCache("userRevisions", true);
        this.cacheManager.defineConfiguration("keys", this.getKeysCacheConfig());
        this.cacheManager.getCache("keys", true);
        ConfigurationBuilder actionTokenCacheConfigBuilder = InfinispanUtil.getActionTokenCacheConfig();
        if (clustered) {
            actionTokenCacheConfigBuilder.simpleCache(false);
            actionTokenCacheConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
        }
        if (jdgEnabled) {
            this.configureRemoteActionTokenCacheStore(actionTokenCacheConfigBuilder, async);
        }
        this.cacheManager.defineConfiguration("actionTokens", actionTokenCacheConfigBuilder.build());
        this.cacheManager.getCache("actionTokens", true);
        long authzRevisionsMaxEntries = this.cacheManager.getCache("authorization").getCacheConfiguration().memory().size();
        authzRevisionsMaxEntries = authzRevisionsMaxEntries > 0L ? 2L * authzRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("authorizationRevisions", this.getRevisionCacheConfig(authzRevisionsMaxEntries));
        this.cacheManager.getCache("authorizationRevisions", true);
    }

    private Configuration getRevisionCacheConfig(long maxEntries) {
        ConfigurationBuilder cb = InfinispanUtil.createCacheConfigurationBuilder();
        cb.simpleCache(false);
        cb.invocationBatching().enable().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        cb.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cb.transaction().lockingMode(LockingMode.PESSIMISTIC);
        if (cb.memory().storage().canStoreReferences()) {
            cb.encoding().mediaType("application/x-java-object");
        }
        cb.memory().evictionStrategy(EvictionStrategy.REMOVE).evictionType(EvictionType.COUNT).size(maxEntries);
        return cb.build();
    }

    private void configureRemoteCacheStore(ConfigurationBuilder builder, boolean async, String cacheName) {
        String jdgServer = this.config.get("remoteStoreHost", "127.0.0.1");
        Integer jdgPort = this.config.getInt("remoteStorePort", Integer.valueOf(11222));
        boolean segmented = this.config.getBoolean("segmented", Boolean.valueOf(false));
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(RemoteStoreConfigurationBuilder.class)).fetchPersistentState(false)).ignoreModifications(false)).purgeOnStartup(false)).preload(false)).shared(true)).remoteCacheName(cacheName).segmented(segmented)).rawValues(true).forceReturnValues(false).marshaller(KeycloakHotRodMarshallerFactory.class.getName()).protocolVersion(this.getHotrodVersion()).addServer().host(jdgServer).port(jdgPort.intValue()).async().enabled(async);
    }

    private void configureRemoteActionTokenCacheStore(ConfigurationBuilder builder, boolean async) {
        String jdgServer = this.config.get("remoteStoreHost", "127.0.0.1");
        Integer jdgPort = this.config.getInt("remoteStorePort", Integer.valueOf(11222));
        boolean segmented = this.config.getBoolean("segmented", Boolean.valueOf(false));
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(RemoteStoreConfigurationBuilder.class)).fetchPersistentState(false)).ignoreModifications(false)).purgeOnStartup(false)).preload(true)).shared(true)).remoteCacheName("actionTokens").segmented(segmented)).rawValues(true).forceReturnValues(false).marshaller(KeycloakHotRodMarshallerFactory.class.getName()).protocolVersion(this.getHotrodVersion()).addServer().host(jdgServer).port(jdgPort.intValue()).async().enabled(async);
    }

    private ProtocolVersion getHotrodVersion() {
        String hotrodVersionStr = this.config.get("hotrodProtocolVersion", ProtocolVersion.DEFAULT_PROTOCOL_VERSION.toString());
        ProtocolVersion hotrodVersion = ProtocolVersion.parseVersion((String)hotrodVersionStr);
        if (hotrodVersion == null) {
            hotrodVersion = ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
        }
        logger.debugf("HotRod protocol version: %s", (Object)hotrodVersion);
        return hotrodVersion;
    }

    protected Configuration getKeysCacheConfig() {
        ConfigurationBuilder cb = InfinispanUtil.createCacheConfigurationBuilder();
        cb.memory().evictionStrategy(EvictionStrategy.REMOVE).evictionType(EvictionType.COUNT).size(1000L);
        cb.expiration().maxIdle(3600L, TimeUnit.SECONDS);
        return cb.build();
    }

    private void registerSystemWideListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener("REALM_CLEAR_CACHE_EVENTS", event -> {
            if (event instanceof ClearCacheEvent) {
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType._ALL_, new Object[0]);
            }
        });
        cluster.registerListener("REALM_INVALIDATION_EVENTS", event -> {
            if (event instanceof RealmUpdatedEvent) {
                RealmUpdatedEvent rr = (RealmUpdatedEvent)event;
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.REALM, new Object[]{rr.getId()});
            } else if (event instanceof RealmRemovedEvent) {
                RealmRemovedEvent rr = (RealmRemovedEvent)event;
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.REALM, new Object[]{rr.getId()});
            }
        });
    }

    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

