/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import io.quarkus.runtime.annotations.RecordableConstructor;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public final class RuntimePersistenceUnitDescriptor
implements PersistenceUnitDescriptor {
    private final String name;
    private final String configurationName;
    private final String providerClassName;
    private final boolean useQuotedIdentifiers;
    private final PersistenceUnitTransactionType transactionType;
    private final ValidationMode validationMode;
    private final SharedCacheMode sharedCacheMode;
    private final List<String> managedClassNames;
    private final Properties properties;

    @Deprecated
    @RecordableConstructor
    public RuntimePersistenceUnitDescriptor(String name, String configurationName, String providerClassName, boolean useQuotedIdentifiers, PersistenceUnitTransactionType transactionType, ValidationMode validationMode, SharedCacheMode sharedCacheMode, List<String> managedClassNames, Properties properties) {
        this.name = name;
        this.configurationName = configurationName;
        this.providerClassName = providerClassName;
        this.useQuotedIdentifiers = useQuotedIdentifiers;
        this.transactionType = transactionType;
        this.validationMode = validationMode;
        this.sharedCacheMode = sharedCacheMode;
        this.managedClassNames = managedClassNames;
        this.properties = properties;
    }

    public static RuntimePersistenceUnitDescriptor validateAndReadFrom(PersistenceUnitDescriptor toClone, String configurationName) {
        Objects.requireNonNull(toClone);
        RuntimePersistenceUnitDescriptor.verifyIgnoredFields(toClone);
        return new RuntimePersistenceUnitDescriptor(toClone.getName(), configurationName, toClone.getProviderClassName(), toClone.isUseQuotedIdentifiers(), toClone.getTransactionType(), toClone.getValidationMode(), toClone.getSharedCacheMode(), Collections.unmodifiableList(toClone.getManagedClassNames()), toClone.getProperties());
    }

    public URL getPersistenceUnitRootUrl() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public boolean isUseQuotedIdentifiers() {
        return this.useQuotedIdentifiers;
    }

    public boolean isExcludeUnlistedClasses() {
        return true;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public List<String> getMappingFileNames() {
        return Collections.emptyList();
    }

    public List<URL> getJarFileUrls() {
        return Collections.emptyList();
    }

    public Object getNonJtaDataSource() {
        return null;
    }

    public Object getJtaDataSource() {
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public ClassLoader getTempClassLoader() {
        return null;
    }

    public void pushClassTransformer(EnhancementContext enhancementContext) {
    }

    private static void verifyIgnoredFields(PersistenceUnitDescriptor toClone) {
        if (toClone.getJarFileUrls() != null && !toClone.getJarFileUrls().isEmpty()) {
            throw new UnsupportedOperationException("Value found for #getJarFileUrls : not supported yet");
        }
        if (toClone.getJtaDataSource() != null) {
            throw new UnsupportedOperationException("Value found for #getJtaDataSource : not supported yet");
        }
        if (toClone.getNonJtaDataSource() != null) {
            throw new UnsupportedOperationException("Value found for #getNonJtaDataSource : not supported");
        }
    }

    public String toString() {
        return "PersistenceUnitDescriptor{name='" + this.name + "', providerClassName='" + this.providerClassName + "', useQuotedIdentifiers=" + this.useQuotedIdentifiers + ", transactionType=" + this.transactionType + ", validationMode=" + this.validationMode + ", sharedCachemode=" + this.sharedCacheMode + ", managedClassNames=" + this.managedClassNames + ", properties=" + this.properties + "}";
    }
}

