/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RolesAllowedHttpSecurityPolicy
implements HttpSecurityPolicy {
    private List<String> rolesAllowed;
    private final boolean grantPermissions;
    private final Map<String, Set<Permission>> roleToPermissions;

    public RolesAllowedHttpSecurityPolicy(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
        this.grantPermissions = false;
        this.roleToPermissions = null;
    }

    public RolesAllowedHttpSecurityPolicy() {
        this.grantPermissions = false;
        this.roleToPermissions = null;
    }

    public RolesAllowedHttpSecurityPolicy(List<String> rolesAllowed, Map<String, Set<Permission>> roleToPermissions) {
        this.rolesAllowed = rolesAllowed;
        this.grantPermissions = true;
        this.roleToPermissions = roleToPermissions;
    }

    public List<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    public RolesAllowedHttpSecurityPolicy setRolesAllowed(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
        return this;
    }

    @Override
    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        return identity.map((Function)new Function<SecurityIdentity, HttpSecurityPolicy.CheckResult>(){

            @Override
            public HttpSecurityPolicy.CheckResult apply(SecurityIdentity securityIdentity) {
                for (String i : RolesAllowedHttpSecurityPolicy.this.rolesAllowed) {
                    if (!securityIdentity.hasRole(i) && (!"**".equals(i) || securityIdentity.isAnonymous())) continue;
                    if (RolesAllowedHttpSecurityPolicy.this.grantPermissions) {
                        return RolesAllowedHttpSecurityPolicy.this.grantPermissions(securityIdentity);
                    }
                    return HttpSecurityPolicy.CheckResult.PERMIT;
                }
                return HttpSecurityPolicy.CheckResult.DENY;
            }
        });
    }

    private HttpSecurityPolicy.CheckResult grantPermissions(SecurityIdentity securityIdentity) {
        Set roles = securityIdentity.getRoles();
        if (roles != null && !roles.isEmpty()) {
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (String role : roles) {
                if (!this.roleToPermissions.containsKey(role)) continue;
                permissions.addAll((Collection<Permission>)this.roleToPermissions.get(role));
            }
            if (!permissions.isEmpty()) {
                return new HttpSecurityPolicy.CheckResult(true, RolesAllowedHttpSecurityPolicy.augmentIdentity(securityIdentity, permissions));
            }
        }
        return HttpSecurityPolicy.CheckResult.PERMIT;
    }

    private static SecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, final Set<Permission> permissions) {
        return new SecurityIdentity(){

            public Principal getPrincipal() {
                return securityIdentity.getPrincipal();
            }

            public boolean isAnonymous() {
                return securityIdentity.isAnonymous();
            }

            public Set<String> getRoles() {
                return securityIdentity.getRoles();
            }

            public boolean hasRole(String s) {
                return securityIdentity.hasRole(s);
            }

            public <T extends Credential> T getCredential(Class<T> aClass) {
                return (T)securityIdentity.getCredential(aClass);
            }

            public Set<Credential> getCredentials() {
                return securityIdentity.getCredentials();
            }

            public <T> T getAttribute(String s) {
                return (T)securityIdentity.getAttribute(s);
            }

            public Map<String, Object> getAttributes() {
                return securityIdentity.getAttributes();
            }

            public Uni<Boolean> checkPermission(Permission requiredPermission) {
                for (Permission possessedPermission : permissions) {
                    if (!possessedPermission.implies(requiredPermission)) continue;
                    return Uni.createFrom().item((Object)true);
                }
                return securityIdentity.checkPermission(requiredPermission);
            }

            public boolean checkPermissionBlocking(Permission requiredPermission) {
                for (Permission possessedPermission : permissions) {
                    if (!possessedPermission.implies(requiredPermission)) continue;
                    return true;
                }
                return securityIdentity.checkPermissionBlocking(requiredPermission);
            }
        };
    }
}

