/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.policy.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.authorization.policy.entity.JpaPolicyConfigEntity;
import org.keycloak.models.map.storage.jpa.authorization.policy.entity.JpaPolicyMetadata;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

@Entity
@Table(name="kc_authz_policy", uniqueConstraints={@UniqueConstraint(columnNames={"realmId", "resourceServerId", "name"})})
@EnhancementInfo(version="6.2.5.Final")
public class JpaPolicyEntity
extends MapPolicyEntity.AbstractMapPolicyEntity
implements JpaRootVersionedEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    UUID id;
    @Version
    @Column
    int version;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaPolicyMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String realmId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    UUID resourceServerId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String name;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String owner;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String type;
    @Column(name="scope_id")
    @ElementCollection
    @CollectionTable(name="kc_authz_policy_scope", joinColumns={@JoinColumn(name="policy_id", nullable=false)})
    Set<UUID> scopeIds = new HashSet<UUID>();
    @Column(name="resource_id")
    @ElementCollection
    @CollectionTable(name="kc_authz_policy_resource", joinColumns={@JoinColumn(name="policy_id", nullable=false)})
    Set<UUID> resourceIds = new HashSet<UUID>();
    @Column(name="associated_policy_id")
    @ElementCollection
    @CollectionTable(name="kc_authz_policy_associated_policy", joinColumns={@JoinColumn(name="policy_id", nullable=false)})
    Set<UUID> policyIds = new HashSet<UUID>();
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    Set<JpaPolicyConfigEntity> config = new HashSet<JpaPolicyConfigEntity>();
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaPolicyEntity() {
        this.metadata = new JpaPolicyMetadata();
    }

    public JpaPolicyEntity(DeepCloner cloner) {
        this.metadata = new JpaPolicyMetadata(cloner);
    }

    public JpaPolicyEntity(UUID id, int version, Integer entityVersion, String realmId, UUID resourceServerId, String name, String owner, String type) {
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_version(version);
        this.$$_hibernate_write_entityVersion(entityVersion);
        this.$$_hibernate_write_realmId(realmId);
        this.$$_hibernate_write_resourceServerId(resourceServerId);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_owner(owner);
        this.$$_hibernate_write_type(type);
        this.metadata = null;
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_AUTHZ_POLICY;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getRealmId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRealmId();
        }
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public String getResourceServerId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getResourceServerId();
        }
        return this.$$_hibernate_read_resourceServerId() == null ? null : this.$$_hibernate_read_resourceServerId().toString();
    }

    public void setResourceServerId(String resourceServerId) {
        this.$$_hibernate_read_metadata().setResourceServerId(resourceServerId);
    }

    public String getName() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getName();
        }
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_read_metadata().setName(name);
    }

    public String getType() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getType();
        }
        return this.$$_hibernate_read_type();
    }

    public void setType(String type) {
        this.$$_hibernate_read_metadata().setType(type);
    }

    public String getDescription() {
        return this.$$_hibernate_read_metadata().getDescription();
    }

    public void setDescription(String description) {
        this.$$_hibernate_read_metadata().setDescription(description);
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.$$_hibernate_read_metadata().getDecisionStrategy();
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.$$_hibernate_read_metadata().setDecisionStrategy(decisionStrategy);
    }

    public Logic getLogic() {
        return this.$$_hibernate_read_metadata().getLogic();
    }

    public void setLogic(Logic logic) {
        this.$$_hibernate_read_metadata().setLogic(logic);
    }

    public Map<String, String> getConfigs() {
        return Collections.unmodifiableMap(this.$$_hibernate_read_config().stream().collect(Collectors.toMap(JpaAttributeEntity::getName, JpaAttributeEntity::getValue)));
    }

    public void setConfigs(Map<String, String> config) {
        this.$$_hibernate_read_config().clear();
        if (config == null) {
            return;
        }
        for (Map.Entry<String, String> entry : config.entrySet()) {
            this.setConfig(entry.getKey(), entry.getValue());
        }
    }

    public String getConfig(String name) {
        return this.$$_hibernate_read_config().stream().filter(obj -> Objects.equals(obj.getName(), name)).findFirst().map(JpaAttributeEntity::getValue).orElse(null);
    }

    public void setConfig(String name, String value) {
        if (name == null || value == null || value.trim().isEmpty()) {
            return;
        }
        JpaPolicyConfigEntity configEntity = new JpaPolicyConfigEntity(this, name, value);
        if (this.$$_hibernate_read_config().contains(configEntity)) {
            this.$$_hibernate_read_config().remove(configEntity);
        }
        this.$$_hibernate_read_config().add(configEntity);
    }

    public void removeConfig(String name) {
        this.$$_hibernate_read_config().removeIf(obj -> Objects.equals(obj.getName(), name));
    }

    public Set<String> getAssociatedPolicyIds() {
        return this.$$_hibernate_read_policyIds().stream().map(UUID::toString).collect(Collectors.toSet());
    }

    public void addAssociatedPolicyId(String policyId) {
        this.$$_hibernate_read_policyIds().add(StringKeyConverter.UUIDKey.INSTANCE.fromString(policyId));
    }

    public void removeAssociatedPolicyId(String policyId) {
        this.$$_hibernate_read_policyIds().remove(StringKeyConverter.UUIDKey.INSTANCE.fromString(policyId));
    }

    public Set<String> getResourceIds() {
        return this.$$_hibernate_read_resourceIds().stream().map(UUID::toString).collect(Collectors.toSet());
    }

    public void addResourceId(String resourceId) {
        this.$$_hibernate_read_resourceIds().add(StringKeyConverter.UUIDKey.INSTANCE.fromString(resourceId));
    }

    public void removeResourceId(String resourceId) {
        this.$$_hibernate_read_resourceIds().remove(StringKeyConverter.UUIDKey.INSTANCE.fromString(resourceId));
    }

    public Set<String> getScopeIds() {
        return this.$$_hibernate_read_scopeIds().stream().map(UUID::toString).collect(Collectors.toSet());
    }

    public void addScopeId(String scopeId) {
        this.$$_hibernate_read_scopeIds().add(StringKeyConverter.UUIDKey.INSTANCE.fromString(scopeId));
    }

    public void removeScopeId(String scopeId) {
        this.$$_hibernate_read_scopeIds().remove(StringKeyConverter.UUIDKey.INSTANCE.fromString(scopeId));
    }

    public String getOwner() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getOwner();
        }
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_read_metadata().setOwner(owner);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaPolicyEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaPolicyEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaPolicyMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaPolicyMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public UUID $$_hibernate_read_resourceServerId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServerId = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceServerId", (Object)this.resourceServerId);
        }
        return this.resourceServerId;
    }

    public void $$_hibernate_write_resourceServerId(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServerId = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceServerId", (Object)this.resourceServerId, (Object)uUID);
            return;
        }
        this.resourceServerId = uUID;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }

    public String $$_hibernate_read_type() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "type", (Object)this.type);
        }
        return this.type;
    }

    public void $$_hibernate_write_type(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "type", (Object)this.type, (Object)string);
            return;
        }
        this.type = string;
    }

    public Set $$_hibernate_read_scopeIds() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopeIds = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "scopeIds", this.scopeIds);
        }
        return this.scopeIds;
    }

    public Set $$_hibernate_read_resourceIds() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceIds = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceIds", this.resourceIds);
        }
        return this.resourceIds;
    }

    public Set $$_hibernate_read_policyIds() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.policyIds = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "policyIds", this.policyIds);
        }
        return this.policyIds;
    }

    public Set $$_hibernate_read_config() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.config = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "config", this.config);
        }
        return this.config;
    }
}

