/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.List;
import java.util.function.Consumer;
import twitter4j.APIResourceBase;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.StringUtil;
import twitter4j.TwitterException;
import twitter4j.v1.FriendsFollowersResources;
import twitter4j.v1.Friendship;
import twitter4j.v1.IDs;
import twitter4j.v1.PagableResponseList;
import twitter4j.v1.Relationship;
import twitter4j.v1.ResponseList;
import twitter4j.v1.User;

class FriendsFollowersResourcesImpl
extends APIResourceBase
implements FriendsFollowersResources {
    FriendsFollowersResourcesImpl(HttpClient http, ObjectFactory factory, String restBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners) {
        super(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
    }

    @Override
    public IDs getNoRetweetsFriendships() throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "friendships/no_retweets/ids.json"));
    }

    @Override
    public IDs getFriendsIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "friends/ids.json?cursor=" + cursor));
    }

    @Override
    public IDs getFriendsIDs(long userId, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "friends/ids.json?user_id=" + userId + "&cursor=" + cursor));
    }

    @Override
    public IDs getFriendsIDs(long userId, long cursor, int count) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "friends/ids.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public IDs getFriendsIDs(String screenName, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "friends/ids.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor)));
    }

    @Override
    public IDs getFriendsIDs(String screenName, long cursor, int count) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "friends/ids.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public IDs getFollowersIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "followers/ids.json?cursor=" + cursor));
    }

    @Override
    public IDs getFollowersIDs(long userId, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "followers/ids.json?user_id=" + userId + "&cursor=" + cursor));
    }

    @Override
    public IDs getFollowersIDs(long userId, long cursor, int count) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "followers/ids.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public IDs getFollowersIDs(String screenName, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "followers/ids.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor)));
    }

    @Override
    public IDs getFollowersIDs(String screenName, long cursor, int count) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "followers/ids.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(long ... ids) throws TwitterException {
        return this.factory.createFriendshipList(this.get(this.restBaseURL + "friendships/lookup.json?user_id=" + StringUtil.join(ids)));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(String ... screenNames) throws TwitterException {
        return this.factory.createFriendshipList(this.get(this.restBaseURL + "friendships/lookup.json?screen_name=" + StringUtil.join(screenNames)));
    }

    @Override
    public IDs getIncomingFriendships(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "friendships/incoming.json?cursor=" + cursor));
    }

    @Override
    public IDs getOutgoingFriendships(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "friendships/outgoing.json?cursor=" + cursor));
    }

    @Override
    public User createFriendship(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "friendships/create.json?user_id=" + userId));
    }

    @Override
    public User createFriendship(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "friendships/create.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public User createFriendship(long userId, boolean follow) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "friendships/create.json?user_id=" + userId + "&follow=" + follow));
    }

    @Override
    public User createFriendship(String screenName, boolean follow) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "friendships/create.json", new HttpParameter("screen_name", screenName), new HttpParameter("follow", follow)));
    }

    @Override
    public User destroyFriendship(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "friendships/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyFriendship(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "friendships/destroy.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public Relationship updateFriendship(long userId, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        return this.factory.createRelationship(this.post(this.restBaseURL + "friendships/update.json", new HttpParameter("user_id", userId), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", retweets)));
    }

    @Override
    public Relationship updateFriendship(String screenName, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        return this.factory.createRelationship(this.post(this.restBaseURL + "friendships/update.json", new HttpParameter("screen_name", screenName), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", retweets)));
    }

    @Override
    public Relationship showFriendship(long sourceId, long targetId) throws TwitterException {
        return this.factory.createRelationship(this.get(this.restBaseURL + "friendships/show.json", new HttpParameter("source_id", sourceId), new HttpParameter("target_id", targetId)));
    }

    @Override
    public Relationship showFriendship(String sourceScreenName, String targetScreenName) throws TwitterException {
        return this.factory.createRelationship(this.get(this.restBaseURL + "friendships/show.json", HttpParameter.getParameterArray("source_screen_name", sourceScreenName, "target_screen_name", targetScreenName)));
    }

    @Override
    public PagableResponseList<User> getFriendsList(long userId, long cursor) throws TwitterException {
        return this.getFriendsList(userId, cursor, 20);
    }

    @Override
    public PagableResponseList<User> getFriendsList(long userId, long cursor, int count) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "friends/list.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public PagableResponseList<User> getFriendsList(String screenName, long cursor) throws TwitterException {
        return this.getFriendsList(screenName, cursor, 20);
    }

    @Override
    public PagableResponseList<User> getFriendsList(String screenName, long cursor, int count) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "friends/list.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public PagableResponseList<User> getFriendsList(long userId, long cursor, int count, boolean skipStatus, boolean includeUserEntities) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "friends/list.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count + "&skip_status=" + skipStatus + "&include_user_entities=" + includeUserEntities));
    }

    @Override
    public PagableResponseList<User> getFriendsList(String screenName, long cursor, int count, boolean skipStatus, boolean includeUserEntities) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "friends/list.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count), new HttpParameter("skip_status", skipStatus), new HttpParameter("include_user_entities", includeUserEntities)));
    }

    @Override
    public PagableResponseList<User> getFollowersList(long userId, long cursor) throws TwitterException {
        return this.getFollowersList(userId, cursor, 20);
    }

    @Override
    public PagableResponseList<User> getFollowersList(String screenName, long cursor) throws TwitterException {
        return this.getFollowersList(screenName, cursor, 20);
    }

    @Override
    public PagableResponseList<User> getFollowersList(long userId, long cursor, int count) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "followers/list.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public PagableResponseList<User> getFollowersList(String screenName, long cursor, int count) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "followers/list.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public PagableResponseList<User> getFollowersList(long userId, long cursor, int count, boolean skipStatus, boolean includeUserEntities) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "followers/list.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count + "&skip_status=" + skipStatus + "&include_user_entities=" + includeUserEntities));
    }

    @Override
    public PagableResponseList<User> getFollowersList(String screenName, long cursor, int count, boolean skipStatus, boolean includeUserEntities) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "followers/list.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count), new HttpParameter("skip_status", skipStatus), new HttpParameter("include_user_entities", includeUserEntities)));
    }
}

