/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public final class InitializersList {
    private final Initializer[] initializers;
    private final Initializer[] sortedNonCollectionsFirst;
    private final Initializer[] sortedForResolveInstance;
    private final boolean hasCollectionInitializers;
    private final Map<NavigablePath, Initializer> initializerMap;

    private InitializersList(Initializer[] initializers, Initializer[] sortedNonCollectionsFirst, Initializer[] sortedForResolveInstance, boolean hasCollectionInitializers, Map<NavigablePath, Initializer> initializerMap) {
        this.initializers = initializers;
        this.sortedNonCollectionsFirst = sortedNonCollectionsFirst;
        this.sortedForResolveInstance = sortedForResolveInstance;
        this.hasCollectionInitializers = hasCollectionInitializers;
        this.initializerMap = initializerMap;
    }

    @Deprecated
    public List<Initializer> asList() {
        return Arrays.asList(this.initializers);
    }

    public Initializer resolveInitializer(NavigablePath path) {
        return this.initializerMap.get(path);
    }

    public void finishUpRow(RowProcessingState rowProcessingState) {
        for (Initializer init : this.initializers) {
            init.finishUpRow(rowProcessingState);
        }
    }

    public void initializeInstance(RowProcessingState rowProcessingState) {
        for (Initializer init : this.initializers) {
            init.initializeInstance(rowProcessingState);
        }
    }

    public void endLoading(ExecutionContext executionContext) {
        for (Initializer initializer : this.initializers) {
            initializer.endLoading(executionContext);
        }
    }

    public void resolveKeys(RowProcessingState rowProcessingState) {
        for (Initializer init : this.sortedNonCollectionsFirst) {
            init.resolveKey(rowProcessingState);
        }
    }

    public void resolveInstances(RowProcessingState rowProcessingState) {
        for (Initializer init : this.sortedForResolveInstance) {
            init.resolveInstance(rowProcessingState);
        }
    }

    public boolean hasCollectionInitializers() {
        return this.hasCollectionInitializers;
    }

    static class Builder {
        private ArrayList<Initializer> initializers = new ArrayList();
        int nonCollectionInitializersNum = 0;
        int resolveFirstNum = 0;

        public void addInitializer(Initializer initializer) {
            this.initializers.add(initializer);
            if (!initializer.isCollectionInitializer()) {
                ++this.nonCollectionInitializersNum;
            }
            if (Builder.initializeFirst(initializer)) {
                ++this.resolveFirstNum;
            }
        }

        private static boolean initializeFirst(Initializer initializer) {
            return !(initializer instanceof EntityDelayedFetchInitializer) && !(initializer instanceof EntitySelectFetchInitializer) && !(initializer instanceof AbstractCollectionInitializer);
        }

        InitializersList build(Map<NavigablePath, Initializer> initializerMap) {
            Initializer[] originalSortInitializers;
            int size = this.initializers.size();
            Initializer[] sortedNonCollectionsFirst = new Initializer[size];
            Initializer[] sortedForResolveInstance = new Initializer[size];
            int nonCollectionIdx = 0;
            int collectionIdx = this.nonCollectionInitializersNum;
            int resolveFirstIdx = 0;
            int resolveLaterIdx = this.resolveFirstNum;
            for (Initializer initializer : originalSortInitializers = this.toArray(this.initializers)) {
                if (initializer.isCollectionInitializer()) {
                    sortedNonCollectionsFirst[collectionIdx++] = initializer;
                } else {
                    sortedNonCollectionsFirst[nonCollectionIdx++] = initializer;
                }
                if (Builder.initializeFirst(initializer)) {
                    sortedForResolveInstance[resolveFirstIdx++] = initializer;
                    continue;
                }
                sortedForResolveInstance[resolveLaterIdx++] = initializer;
            }
            boolean hasCollectionInitializers = this.nonCollectionInitializersNum != this.initializers.size();
            return new InitializersList(originalSortInitializers, sortedNonCollectionsFirst, sortedForResolveInstance, hasCollectionInitializers, initializerMap);
        }

        private Initializer[] toArray(ArrayList<Initializer> initializers) {
            return initializers.toArray(new Initializer[initializers.size()]);
        }
    }
}

