/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import liquibase.exception.CustomChangeException;
import liquibase.statement.core.RawSqlStatement;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate19_0_0_DefaultPostLogoutRedirectUri
extends CustomKeycloakTask {
    private static final String POST_LOGOUT_REDIRECT_URIS = "post.logout.redirect.uris";

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String clientAttributesTable = this.getTableName("CLIENT_ATTRIBUTES");
        String redirectUrisTable = this.getTableName("REDIRECT_URIS");
        this.statements.add(new RawSqlStatement("INSERT INTO " + clientAttributesTable + " (CLIENT_ID,NAME,VALUE) SELECT DISTINCT CLIENT_ID, '" + POST_LOGOUT_REDIRECT_URIS + "', '+' FROM " + redirectUrisTable + " WHERE CLIENT_ID NOT IN (SELECT CLIENT_ID FROM " + clientAttributesTable + " WHERE NAME = '" + POST_LOGOUT_REDIRECT_URIS + "')"));
    }

    @Override
    protected String getTaskId() {
        return "Default post_logout_redirect_uris (19.0.0)";
    }
}

