/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Optional;
import org.keycloak.config.ImportOptions;
import org.keycloak.exportimport.Strategy;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import picocli.CommandLine;

final class ImportPropertyMappers {
    private ImportPropertyMappers() {
    }

    public static PropertyMapper<?>[] getMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(ImportOptions.FILE).to("kc.spi-import-importer").transformer(ImportPropertyMappers::transformImporter).paramLabel("file").build(), PropertyMapper.fromOption(ImportOptions.FILE).to("kc.spi-import-single-file-file").paramLabel("file").build(), PropertyMapper.fromOption(ImportOptions.DIR).to("kc.spi-import-dir-dir").paramLabel("dir").build(), PropertyMapper.fromOption(ImportOptions.OVERRIDE).to("kc.spi-import-single-file-strategy").transformer(ImportPropertyMappers::transformOverride).build(), PropertyMapper.fromOption(ImportOptions.OVERRIDE).to("kc.spi-import-dir-strategy").transformer(ImportPropertyMappers::transformOverride).build()};
    }

    private static Optional<String> transformOverride(Optional<String> option, ConfigSourceInterceptorContext context) {
        if (option.isPresent() && Boolean.parseBoolean(option.get())) {
            return Optional.of(Strategy.OVERWRITE_EXISTING.name());
        }
        return Optional.of(Strategy.IGNORE_EXISTING.name());
    }

    private static Optional<String> transformImporter(Optional<String> option, ConfigSourceInterceptorContext context) {
        ConfigValue importer = context.proceed("kc.spi-import-importer");
        if (importer != null) {
            return Optional.of(importer.getValue());
        }
        if (option.isPresent()) {
            return Optional.of("singleFile");
        }
        ConfigValue dirConfigValue = context.proceed("kc.spi-import-dir-dir");
        if (dirConfigValue != null && dirConfigValue.getValue() != null) {
            return Optional.of("dir");
        }
        ConfigValue dirValue = context.proceed("kc.dir");
        if (dirConfigValue != null && dirValue.getValue() != null) {
            return Optional.of("dir");
        }
        if (System.getProperty("keycloak.migration.provider") == null) {
            throw new CommandLine.PicocliException("Must specify either --dir or --file options.");
        }
        return Optional.empty();
    }
}

