/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.scanning;

import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.InterceptorContainer;
import org.jboss.resteasy.reactive.common.model.PreMatchInterceptorContainer;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.processor.NameBindingUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResteasyReactiveInterceptorScanner {
    private ResteasyReactiveInterceptorScanner() {
    }

    public static ResourceInterceptors createResourceInterceptors(IndexView indexView, ApplicationScanningResult result) {
        return ResteasyReactiveInterceptorScanner.createResourceInterceptors(indexView, result, null);
    }

    public static ResourceInterceptors createResourceInterceptors(IndexView indexView, ApplicationScanningResult result, Function<String, BeanFactory<?>> factoryCreator) {
        ResourceInterceptors interceptors = new ResourceInterceptors();
        ResteasyReactiveInterceptorScanner.scanForContainerRequestFilters(interceptors, indexView, result);
        ResteasyReactiveInterceptorScanner.scanForIOInterceptors(interceptors, indexView, result);
        if (factoryCreator != null) {
            interceptors.initializeDefaultFactories(factoryCreator);
        }
        return interceptors;
    }

    public static void scanForContainerRequestFilters(ResourceInterceptors interceptors, IndexView index, ApplicationScanningResult applicationScanningResult) {
        HashSet<ClassInfo> specReqFilters = new HashSet<ClassInfo>(index.getAllKnownImplementors(ResteasyReactiveDotNames.CONTAINER_REQUEST_FILTER));
        HashSet allReqFilters = new HashSet(specReqFilters);
        allReqFilters.addAll(index.getAllKnownImplementors(ResteasyReactiveDotNames.RESTEASY_REACTIVE_CONTAINER_REQUEST_FILTER));
        for (ClassInfo filterClass : allReqFilters) {
            ResourceInterceptor interceptor = ResteasyReactiveInterceptorScanner.handleDiscoveredInterceptor(applicationScanningResult, interceptors.getContainerRequestFilters(), index, filterClass);
            if (interceptor == null) continue;
            ResteasyReactiveInterceptorScanner.setFilterMethodSourceForReqFilter(index, specReqFilters, filterClass, interceptor);
        }
        HashSet<ClassInfo> specRespFilters = new HashSet<ClassInfo>(index.getAllKnownImplementors(ResteasyReactiveDotNames.CONTAINER_RESPONSE_FILTER));
        HashSet allRespFilters = new HashSet(specRespFilters);
        allRespFilters.addAll(index.getAllKnownImplementors(ResteasyReactiveDotNames.RESTEASY_REACTIVE_CONTAINER_RESPONSE_FILTER));
        for (ClassInfo filterClass : allRespFilters) {
            ResourceInterceptor interceptor = ResteasyReactiveInterceptorScanner.handleDiscoveredInterceptor(applicationScanningResult, interceptors.getContainerResponseFilters(), index, filterClass);
            if (interceptor == null) continue;
            ResteasyReactiveInterceptorScanner.setFilterMethodSourceForRespFilter(index, specRespFilters, filterClass, interceptor);
        }
    }

    private static void setFilterMethodSourceForReqFilter(IndexView index, Collection<ClassInfo> specRequestFilters, ClassInfo filterClass, ResourceInterceptor<ContainerRequestFilter> interceptor) {
        boolean isSpecFilter = specRequestFilters.contains(filterClass);
        ClassInfo ci = filterClass;
        MethodInfo filterSourceMethod = null;
        block0: do {
            for (MethodInfo method : ci.methods()) {
                if (!method.name().equals("filter") || method.parametersCount() != 1) continue;
                List parameterTypes = method.parameterTypes();
                if (isSpecFilter) {
                    if (!((Type)parameterTypes.get(0)).name().equals((Object)ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT)) continue;
                    filterSourceMethod = method;
                    continue block0;
                }
                if (!((Type)parameterTypes.get(0)).name().equals((Object)ResteasyReactiveDotNames.RESTEASY_REACTIVE_CONTAINER_REQUEST_CONTEXT)) continue;
                filterSourceMethod = method;
                continue block0;
            }
        } while (filterSourceMethod == null && !ResteasyReactiveDotNames.OBJECT.equals((Object)ci.superName()) && (ci = index.getClassByName(ci.superName())) != null);
        if (filterSourceMethod != null) {
            interceptor.metadata = Map.of("filterSourceMethod", filterSourceMethod);
        }
    }

    private static void setFilterMethodSourceForRespFilter(IndexView index, Collection<ClassInfo> specResponseFilters, ClassInfo filterClass, ResourceInterceptor<ContainerResponseFilter> interceptor) {
        boolean isSpecFilter = specResponseFilters.contains(filterClass);
        ClassInfo ci = filterClass;
        MethodInfo filterSourceMethod = null;
        block0: do {
            for (MethodInfo method : ci.methods()) {
                if (!method.name().equals("filter") || method.parametersCount() != 2) continue;
                List parameterTypes = method.parameterTypes();
                if (isSpecFilter) {
                    if (!((Type)parameterTypes.get(0)).name().equals((Object)ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT) || !((Type)parameterTypes.get(1)).name().equals((Object)ResteasyReactiveDotNames.CONTAINER_RESPONSE_CONTEXT)) continue;
                    filterSourceMethod = method;
                    continue block0;
                }
                if (!((Type)parameterTypes.get(0)).name().equals((Object)ResteasyReactiveDotNames.RESTEASY_REACTIVE_CONTAINER_REQUEST_CONTEXT) || !((Type)parameterTypes.get(1)).name().equals((Object)ResteasyReactiveDotNames.CONTAINER_RESPONSE_CONTEXT)) continue;
                filterSourceMethod = method;
                continue block0;
            }
        } while (filterSourceMethod == null && !ResteasyReactiveDotNames.OBJECT.equals((Object)ci.superName()) && (ci = index.getClassByName(ci.superName())) != null);
        if (filterSourceMethod != null) {
            interceptor.metadata = Map.of("filterSourceMethod", filterSourceMethod);
        }
    }

    public static void scanForIOInterceptors(ResourceInterceptors interceptors, IndexView index, ApplicationScanningResult applicationScanningResult) {
        Collection readerInterceptors = index.getAllKnownImplementors(ResteasyReactiveDotNames.READER_INTERCEPTOR);
        Collection writerInterceptors = index.getAllKnownImplementors(ResteasyReactiveDotNames.WRITER_INTERCEPTOR);
        for (ClassInfo filterClass : writerInterceptors) {
            ResteasyReactiveInterceptorScanner.handleDiscoveredInterceptor(applicationScanningResult, interceptors.getWriterInterceptors(), index, filterClass);
        }
        for (ClassInfo filterClass : readerInterceptors) {
            ResteasyReactiveInterceptorScanner.handleDiscoveredInterceptor(applicationScanningResult, interceptors.getReaderInterceptors(), index, filterClass);
        }
    }

    private static <T> ResourceInterceptor<T> handleDiscoveredInterceptor(ApplicationScanningResult applicationResultBuildItem, InterceptorContainer<T> interceptorContainer, IndexView index, ClassInfo filterClass) {
        if (Modifier.isAbstract(filterClass.flags())) {
            return null;
        }
        ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationResultBuildItem.keepProvider(filterClass);
        if (keepProviderResult != ApplicationScanningResult.KeepProviderResult.DISCARD) {
            AnnotationInstance nonBlockingInstance;
            ResourceInterceptor interceptor = interceptorContainer.create();
            interceptor.setClassName(filterClass.name().toString());
            interceptor.setNameBindingNames(NameBindingUtil.nameBindingNames(index, filterClass));
            AnnotationInstance priorityInstance = filterClass.declaredAnnotation(ResteasyReactiveDotNames.PRIORITY);
            if (priorityInstance != null) {
                interceptor.setPriority(Integer.valueOf(priorityInstance.value().asInt()));
            }
            if ((nonBlockingInstance = filterClass.declaredAnnotation(ResteasyReactiveDotNames.NON_BLOCKING)) != null) {
                interceptor.setNonBlockingRequired(true);
            }
            if (interceptorContainer instanceof PreMatchInterceptorContainer && filterClass.declaredAnnotation(ResteasyReactiveDotNames.PRE_MATCHING) != null) {
                ((PreMatchInterceptorContainer)interceptorContainer).addPreMatchInterceptor(interceptor);
            } else {
                Set nameBindingNames = interceptor.getNameBindingNames();
                if (nameBindingNames.isEmpty() || ResteasyReactiveInterceptorScanner.namePresent(nameBindingNames, applicationResultBuildItem.getGlobalNameBindings())) {
                    interceptorContainer.addGlobalRequestInterceptor(interceptor);
                } else {
                    interceptorContainer.addNameRequestInterceptor(interceptor);
                }
            }
            return interceptor;
        }
        return null;
    }

    private static boolean namePresent(Set<String> nameBindingNames, Set<String> globalNameBindings) {
        for (String i : globalNameBindings) {
            if (!nameBindingNames.contains(i)) continue;
            return true;
        }
        return false;
    }
}

