/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authorization;

import java.util.Objects;
import java.util.Set;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.api.annotations.indexing.Keyword;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodPolicyEntityDelegate;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodPolicyEntitySchemaImpl;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodStringPair;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;

@Indexed
@ProtoDoc(value="schema-version: 1")
public class HotRodPolicyEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @Basic(projectable=true)
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @Basic(projectable=true, sortable=true)
    @ProtoField(number=2)
    public String id;
    @Basic(sortable=true)
    @ProtoField(number=3)
    public String realmId;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=4)
    public String name;
    @ProtoField(number=5)
    public String description;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=6)
    public String type;
    @ProtoField(number=7)
    public Integer decisionStrategy;
    @ProtoField(number=8)
    public Integer logic;
    @Basic(sortable=true)
    @ProtoField(number=9)
    public Set<HotRodStringPair> configs;
    @Basic(sortable=true)
    @ProtoField(number=10)
    public String resourceServerId;
    @Basic(sortable=true)
    @ProtoField(number=11)
    public Set<String> associatedPolicyIds;
    @Basic(sortable=true)
    @ProtoField(number=12)
    public Set<String> resourceIds;
    @Basic(sortable=true)
    @ProtoField(number=13)
    public Set<String> scopeIds;
    @Basic(sortable=true)
    @ProtoField(number=14)
    public String owner;

    public boolean equals(Object o) {
        return HotRodPolicyEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodPolicyEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodPolicyEntity
    extends UpdatableHotRodEntityDelegateImpl<HotRodPolicyEntity>
    implements MapPolicyEntity {
        public String getId() {
            return ((HotRodPolicyEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodPolicyEntity entity = (HotRodPolicyEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setName(String name) {
            HotRodPolicyEntity entity = (HotRodPolicyEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.name, name);
            entity.name = name;
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodPolicyEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodPolicyEntitySchema
    extends GeneratedSchema {
        public static final HotRodPolicyEntitySchema INSTANCE = new HotRodPolicyEntitySchemaImpl();
    }
}

