/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import jakarta.persistence.OptimisticLockException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CrudOperations;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.storage.hotRod.IckleQueryMapModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.common.HotRodUtils;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.locking.HotRodLocksUtils;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.LockObjectsForModification;
import org.keycloak.utils.StreamsUtil;

public class HotRodCrudOperations<K, E extends AbstractHotRodEntity, V extends AbstractEntity & HotRodEntityDelegate<E>, M>
implements CrudOperations<V, M> {
    private static final Logger LOG = Logger.getLogger(HotRodCrudOperations.class);
    private final KeycloakSession session;
    private final RemoteCache<K, E> remoteCache;
    protected final StringKeyConverter<K> keyConverter;
    protected final HotRodEntityDescriptor<E, V> storedEntityDescriptor;
    private final Function<E, V> delegateProducer;
    protected final DeepCloner cloner;
    protected boolean isExpirableEntity;
    private final Map<SearchableModelField<? super M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<K, V, M>> fieldPredicates;
    private final Long lockTimeout;
    private final RemoteCache<String, String> locksCache;
    private final Map<K, Long> entityVersionCache = new HashMap<K, Long>();

    public HotRodCrudOperations(KeycloakSession session, RemoteCache<K, E> remoteCache, StringKeyConverter<K> keyConverter, HotRodEntityDescriptor<E, V> storedEntityDescriptor, DeepCloner cloner, Long lockTimeout) {
        this.session = session;
        this.remoteCache = remoteCache;
        this.keyConverter = keyConverter;
        this.storedEntityDescriptor = storedEntityDescriptor;
        this.cloner = cloner;
        this.delegateProducer = storedEntityDescriptor.getHotRodDelegateProvider();
        this.isExpirableEntity = ExpirableEntity.class.isAssignableFrom(ModelEntityUtil.getEntityType(storedEntityDescriptor.getModelTypeClass()));
        this.fieldPredicates = MapFieldPredicates.getPredicates(storedEntityDescriptor.getModelTypeClass());
        this.lockTimeout = lockTimeout;
        HotRodConnectionProvider cacheProvider = (HotRodConnectionProvider)session.getProvider(HotRodConnectionProvider.class);
        this.locksCache = cacheProvider.getRemoteCache("locks");
    }

    public V create(V value) {
        Long lifespan;
        Object key = this.keyConverter.fromStringSafe(value.getId());
        if (key == null) {
            key = this.keyConverter.yieldNewUniqueKey();
            value = this.cloner.from(this.keyConverter.keyToString(key), value);
        }
        if (this.isExpirableEntity && (lifespan = this.getLifespan(value)) != null) {
            if (lifespan > 0L) {
                this.remoteCache.putIfAbsent(key, (Object)((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()), lifespan.longValue(), TimeUnit.MILLISECONDS);
            } else {
                LOG.warnf("Skipped creation of entity %s in storage due to negative/zero lifespan.", key);
            }
            return value;
        }
        this.remoteCache.putIfAbsent(key, (Object)((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()));
        return value;
    }

    private String getLockName(String key) {
        return this.storedEntityDescriptor.getModelTypeClass().getName() + "_" + key;
    }

    public V read(String key) {
        MetadataValue entityWithMetadata;
        Objects.requireNonNull(key, "Key must be non-null");
        Object k = this.keyConverter.fromStringSafe(key);
        if (LockObjectsForModification.isEnabled((KeycloakSession)this.session, this.storedEntityDescriptor.getModelTypeClass())) {
            final String lockName = this.getLockName(key);
            HotRodLocksUtils.repeatPutIfAbsent(this.locksCache, lockName, Duration.ofMillis(this.lockTimeout), 50, true);
            this.session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AbstractKeycloakTransaction(){

                protected void commitImpl() {
                    HotRodLocksUtils.removeWithInstanceIdentifier(HotRodCrudOperations.this.locksCache, lockName);
                }

                protected void rollbackImpl() {
                    HotRodLocksUtils.removeWithInstanceIdentifier(HotRodCrudOperations.this.locksCache, lockName);
                }
            });
        }
        if ((entityWithMetadata = this.remoteCache.getWithMetadata(k)) == null) {
            return null;
        }
        LOG.tracef("Entity %s read in version %s.%s", (Object)key, (Object)entityWithMetadata.getVersion(), StackUtil.getShortStackTrace());
        this.entityVersionCache.put(k, entityWithMetadata.getVersion());
        return (V)(entityWithMetadata.getValue() != null ? (AbstractEntity)this.delegateProducer.apply((AbstractHotRodEntity)entityWithMetadata.getValue()) : null);
    }

    public V update(V value) {
        Long lifespan;
        Object key = this.keyConverter.fromStringSafe(value.getId());
        if (this.isExpirableEntity && (lifespan = this.getLifespan(value)) != null) {
            if (lifespan > 0L) {
                if (!this.remoteCache.replaceWithVersion(key, (Object)((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()), this.entityVersionCache.get(key).longValue(), lifespan.longValue(), TimeUnit.MILLISECONDS, -1L, TimeUnit.MILLISECONDS)) {
                    throw new OptimisticLockException("Entity " + key + " with version " + this.entityVersionCache.get(key) + " already changed by a different transaction.");
                }
            } else {
                LOG.warnf("Removing entity %s from storage due to negative/zero lifespan.%s", key, StackUtil.getShortStackTrace());
                if (!this.remoteCache.removeWithVersion(key, this.entityVersionCache.get(key).longValue())) {
                    throw new OptimisticLockException("Entity " + key + " with version " + this.entityVersionCache.get(key) + " already changed by a different transaction.");
                }
            }
            return (V)((AbstractEntity)this.delegateProducer.apply((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()));
        }
        if (!this.remoteCache.replaceWithVersion(key, (Object)((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()), this.entityVersionCache.get(key).longValue())) {
            throw new OptimisticLockException("Entity " + key + " with version " + this.entityVersionCache.get(key) + " already changed by a different transaction.");
        }
        return (V)((AbstractEntity)this.delegateProducer.apply((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()));
    }

    public boolean delete(String key) {
        Object k = this.keyConverter.fromStringSafe(key);
        Long entityVersion = this.entityVersionCache.get(k);
        if (entityVersion != null) {
            if (!this.remoteCache.removeWithVersion(k, entityVersion.longValue())) {
                throw new OptimisticLockException("Entity " + key + " with version " + entityVersion + " already changed by a different transaction.");
            }
            return true;
        }
        return this.remoteCache.remove(k) != null;
    }

    private static String toOrderString(QueryParameters.OrderBy<?> orderBy) {
        SearchableModelField field = orderBy.getModelField();
        String modelFieldName = IckleQueryMapModelCriteriaBuilder.getFieldName(field);
        String orderString = orderBy.getOrder().equals((Object)QueryParameters.Order.ASCENDING) ? "ASC" : "DESC";
        return modelFieldName + " " + orderString;
    }

    public Stream<V> read(QueryParameters<M> queryParameters) {
        DefaultModelCriteria dmc = queryParameters.getModelCriteriaBuilder();
        String id = (String)dmc.getSingleRestrictionArgument("id");
        if (id != null) {
            boolean fulfillsQueryCriteria;
            MapModelCriteriaBuilder mapMcb = (MapModelCriteriaBuilder)dmc.flashToModelCriteriaBuilder((ModelCriteriaBuilder)new MapModelCriteriaBuilder(this.keyConverter, this.fieldPredicates));
            V entity = this.read(id);
            if (entity == null) {
                return Stream.empty();
            }
            Object k = this.keyConverter.fromString(id);
            boolean bl = fulfillsQueryCriteria = mapMcb.getKeyFilter().test(k) && mapMcb.getEntityFilter().test(entity);
            if (!fulfillsQueryCriteria) {
                if (LockObjectsForModification.isEnabled((KeycloakSession)this.session, this.storedEntityDescriptor.getModelTypeClass())) {
                    HotRodLocksUtils.removeWithInstanceIdentifier(this.locksCache, this.getLockName(id));
                    this.entityVersionCache.remove(k);
                }
                return Stream.empty();
            }
            return Stream.of(entity);
        }
        if (!dmc.isEmpty() && ((DefaultModelCriteria)dmc.partiallyEvaluate((field, op, arg) -> field == UserSessionModel.SearchableFields.CLIENT_ID || field == UserSessionModel.SearchableFields.CORRESPONDING_SESSION_ID)).toString().contains("__TRUE__")) {
            Query query = this.prepareQueryWithPrefixAndParameters(null, queryParameters);
            CloseableIterator iterator = HotRodUtils.paginateQuery(query, queryParameters.getOffset(), queryParameters.getLimit()).iterator();
            return ((Stream)StreamsUtil.closing(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false)).onClose(() -> ((CloseableIterator)iterator).close())).filter(Objects::nonNull).map(this.delegateProducer);
        }
        Query query = this.prepareQueryWithPrefixAndParameters("SELECT id ", queryParameters);
        CloseableIterator iterator = HotRodUtils.paginateQuery(query, queryParameters.getOffset(), queryParameters.getLimit()).iterator();
        return ((Stream)StreamsUtil.closing(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false)).onClose(() -> ((CloseableIterator)iterator).close())).map(a -> a[0]).map(String.class::cast).map(this::read).filter(x$0 -> Objects.nonNull(x$0));
    }

    private <T> Query<T> prepareQueryWithPrefixAndParameters(String prefix, QueryParameters<M> queryParameters) {
        IckleQueryMapModelCriteriaBuilder iqmcb = (IckleQueryMapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        String queryString = (prefix != null ? prefix : "") + iqmcb.getIckleQuery();
        if (!queryParameters.getOrderBy().isEmpty()) {
            queryString = queryString + " ORDER BY " + queryParameters.getOrderBy().stream().map(HotRodCrudOperations::toOrderString).collect(Collectors.joining(", "));
        }
        LOG.tracef("Preparing Ickle query: '%s'%s", (Object)queryString, StackUtil.getShortStackTrace());
        QueryFactory queryFactory = Search.getQueryFactory(this.remoteCache);
        Query query = queryFactory.create(queryString);
        query.setParameters(iqmcb.getParameters());
        return query;
    }

    public long getCount(QueryParameters<M> queryParameters) {
        IckleQueryMapModelCriteriaBuilder iqmcb = (IckleQueryMapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        String queryString = iqmcb.getIckleQuery();
        LOG.tracef("Executing count Ickle query: %s", (Object)queryString);
        QueryFactory queryFactory = Search.getQueryFactory(this.remoteCache);
        Query query = queryFactory.create(queryString);
        query.setParameters(iqmcb.getParameters());
        return query.execute().hitCount().orElse(0L);
    }

    public long delete(QueryParameters<M> queryParameters) {
        if (queryParameters.getLimit() != null || queryParameters.getOffset() != null) {
            throw new IllegalArgumentException("HotRod storage does not support pagination for delete query");
        }
        Query query = this.prepareQueryWithPrefixAndParameters("DELETE ", queryParameters);
        return query.executeStatement();
    }

    public boolean exists(String key) {
        Objects.requireNonNull(key, "Key must be non-null");
        Object k = this.keyConverter.fromStringSafe(key);
        return this.remoteCache.containsKey(k);
    }

    public IckleQueryMapModelCriteriaBuilder<E, M> createCriteriaBuilder() {
        return new IckleQueryMapModelCriteriaBuilder(this.storedEntityDescriptor.getEntityTypeClass());
    }

    private Long getLifespan(V value) {
        Long expiration = ((ExpirableEntity)value).getExpiration();
        return expiration != null ? Long.valueOf(expiration - Time.currentTimeMillis()) : null;
    }
}

