/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HotRodVersionUtils {
    private static final Pattern schemaVersionPattern = Pattern.compile("schema-version: (\\d+)$", 8);

    public static boolean isVersion2NewerThanVersion1(Integer version1, Integer version2) {
        return version1 < version2;
    }

    public static boolean adjacentVersions(Integer version1, Integer version2) {
        return Math.abs(version1 - version2) == 1;
    }

    public static Integer parseSchemaVersionFromProtoFile(String protoFile) {
        Matcher matcher = schemaVersionPattern.matcher(protoFile);
        if (matcher.find()) {
            if (matcher.groupCount() > 1) {
                throw new IllegalStateException("More than one occurrence of schema-version definitions within one proto file " + protoFile);
            }
            return Integer.parseInt(matcher.group(1));
        }
        return null;
    }
}

